/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.util;

import com.szboanda.android.platform.util.SecurityHelper;
import java.security.MessageDigest;

public class MessageDigestHelper {
    private String algorithm = "SHA-1";
    private MessageDigest messageDigest = null;

    public MessageDigestHelper() {
        this.init();
    }

    private void init() {
        try {
            this.messageDigest = MessageDigest.getInstance(this.algorithm);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public MessageDigestHelper(String algorithm) {
        this.algorithm = algorithm;
        this.init();
    }

    public byte[] getBytesDigest(String message) {
        if (message == null) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u5bf9\u7a7a\u6587\u672c\u63d0\u53d6\u6d88\u606f\u6458\u8981");
        }
        this.messageDigest.update(message.getBytes());
        return this.messageDigest.digest();
    }

    public byte[] getBytesDigest(byte[] message) {
        if (message == null) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u5bf9\u7a7a\u6587\u672c\u63d0\u53d6\u6d88\u606f\u6458\u8981");
        }
        this.messageDigest.update(message);
        return this.messageDigest.digest();
    }

    public String getHexStringDigest(String message) {
        return SecurityHelper.toHex(this.getBytesDigest(message));
    }

    public String getHexStringDigest(byte[] message) {
        return SecurityHelper.toHex(this.getBytesDigest(message));
    }

    public static void main(String[] args) throws Exception {
        MessageDigestHelper helper = new MessageDigestHelper();
        System.out.println(helper.getHexStringDigest("weblogic"));
    }
}

