/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.util;

import android.content.Context;
import android.location.LocationManager;
import android.util.Log;
import com.baidu.location.BDLocation;
import com.baidu.location.BDLocationListener;
import com.baidu.location.LocationClient;
import com.baidu.location.LocationClientOption;
import com.szboanda.android.platform.util.NetworkUtils;
import java.util.HashSet;
import java.util.Set;

public class LocationHelper {
    public static final int DEFAULT_SCANSPAN = 5000;
    private static final String TAG = "LocationHelper.java";
    static Set<Integer> CodeKeyError = new HashSet<Integer>();
    static Set<Integer> CodeEftLoc = new HashSet<Integer>();
    private static volatile LocationHelper INSTANCE;
    private static Object mLock;
    private Context mContext;
    private LocationClient mClient;
    private LocationClientOption mOption;
    private PinLocationListener mListener;
    private boolean isRegisteredListener = false;
    private int scanSpan = 0;
    private BDLocationListener mBDListener = new BDLocationListener(){

        public void onReceiveLocation(BDLocation location) {
            int locType;
            if (LocationHelper.this.scanSpan < 1000) {
                LocationHelper.this.stopLocation();
            }
            if (CodeEftLoc.contains(locType = location.getLocType())) {
                LocationHelper.this.mListener.onSucess(location);
            } else if (CodeKeyError.contains(locType)) {
                Log.e((String)LocationHelper.TAG, (String)("\u8bf7\u6b63\u786e\u914d\u7f6e\u767e\u5ea6KEY, \u9519\u8bef\u4ee3\u7801\uff1a" + locType));
            } else {
                LocationHelper.this.mListener.onFailure(locType);
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocationHelper getInstance() {
        if (INSTANCE == null) {
            Object object = mLock;
            synchronized (object) {
                if (INSTANCE == null) {
                    INSTANCE = new LocationHelper();
                }
            }
        }
        return INSTANCE;
    }

    public void initContext(Context context) {
        this.mContext = context;
        this.scanSpan = 5000;
    }

    public void setScanSpan(int scanSpan) {
        this.scanSpan = scanSpan;
        if (this.mOption != null) {
            this.mOption.setScanSpan(scanSpan);
        }
    }

    public int getScanSpan() {
        return this.scanSpan;
    }

    public void startLocation() {
        this.startLocation(NetworkUtils.isNetworkOpened(this.mContext), null);
    }

    public void startLocation(boolean isNetConnected) {
        this.startLocation(isNetConnected, null);
    }

    public void startLocation(PinLocationListener listener) {
        this.startLocation(NetworkUtils.isNetworkOpened(this.mContext), listener);
    }

    public void startLocation(boolean isNetConnected, PinLocationListener listener) {
        if (this.mClient == null) {
            boolean inited = this.initOptions(isNetConnected);
            if (!inited) {
                return;
            }
            this.mClient = new LocationClient(this.mContext);
            this.mClient.setLocOption(this.mOption);
        }
        if (listener != null) {
            this.mListener = listener;
            this.mClient.unRegisterLocationListener(this.mBDListener);
            this.mClient.registerLocationListener(this.mBDListener);
            this.isRegisteredListener = true;
        }
        if (this.mClient.isStarted()) {
            if (isNetConnected) {
                this.mClient.requestLocation();
            } else {
                this.mClient.requestOfflineLocation();
            }
        } else {
            this.mClient.start();
        }
    }

    private boolean initOptions(boolean isNetConnected) {
        if (this.mOption == null) {
            this.mOption = new LocationClientOption();
            this.mOption.setCoorType("bd09ll");
            if (isNetConnected) {
                if (LocationHelper.isGpsOpened(this.mContext)) {
                    this.mOption.setLocationMode(LocationClientOption.LocationMode.Hight_Accuracy);
                    this.mOption.setOpenGps(true);
                } else {
                    this.mOption.setLocationMode(LocationClientOption.LocationMode.Battery_Saving);
                }
            } else if (LocationHelper.isGpsOpened(this.mContext)) {
                this.mOption.setOpenGps(true);
                this.mOption.setProdName("gps");
                this.mOption.setLocationMode(LocationClientOption.LocationMode.Device_Sensors);
            } else {
                return false;
            }
            this.mOption.setScanSpan(this.scanSpan);
            this.mOption.setIsNeedAddress(true);
            this.mOption.setNeedDeviceDirect(true);
            this.mOption.setTimeOut(10000);
            return true;
        }
        return true;
    }

    public void stopLocation() {
        if (this.isRegisteredListener) {
            this.mClient.unRegisterLocationListener(this.mBDListener);
            this.isRegisteredListener = false;
        }
        if (this.mClient != null) {
            this.mClient.stop();
        }
    }

    public static boolean isGpsOpened(Context context) {
        boolean isOpen = false;
        LocationManager locMag = (LocationManager)context.getSystemService("location");
        if (locMag.isProviderEnabled("gps")) {
            isOpen = true;
        }
        return isOpen;
    }

    public void setOption(LocationClientOption option) {
        this.mOption = option;
    }

    public boolean isStoped() {
        return this.mClient == null || !this.mClient.isStarted();
    }

    static {
        CodeEftLoc.add(61);
        CodeEftLoc.add(65);
        CodeEftLoc.add(66);
        CodeEftLoc.add(68);
        CodeEftLoc.add(161);
        CodeKeyError.add(501);
        CodeKeyError.add(502);
        CodeKeyError.add(505);
        CodeKeyError.add(601);
        CodeKeyError.add(602);
        CodeKeyError.add(700);
        INSTANCE = null;
        mLock = new Object();
    }

    public static interface PinLocationListener {
        public void onSucess(BDLocation var1);

        public void onFailure(int var1);
    }
}

