/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.util;

import android.text.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonUtils {
    public static JSONObject parseJsonObject(String jsonStr) {
        JSONObject jsonObject = null;
        if (!TextUtils.isEmpty((CharSequence)jsonStr)) {
            try {
                int index = jsonStr.indexOf("{");
                int end = jsonStr.lastIndexOf("}");
                jsonStr = jsonStr.substring(index, end + 1);
                jsonObject = new JSONObject(jsonStr);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return jsonObject;
    }

    public static JSONArray parseJsonArray(String jsonStr) {
        JSONArray jsonObject = new JSONArray();
        if (!TextUtils.isEmpty((CharSequence)jsonStr)) {
            try {
                int index = jsonStr.indexOf("[");
                int end = jsonStr.lastIndexOf("]");
                jsonStr = jsonStr.substring(index, end + 1);
                jsonObject = new JSONArray(jsonStr);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return jsonObject;
    }

    public static boolean emptyJsonArray(JSONArray jsonArray) {
        return jsonArray == null || jsonArray.length() < 1;
    }

    public static void put(JSONObject object, String field, Object value) {
        if (field != null) {
            try {
                object.put(field, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static Map<String, Object> parseJsonToMap(JSONObject jsonObj) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (jsonObj != null) {
            Iterator keys = jsonObj.keys();
            while (keys.hasNext()) {
                String keyt = (String)keys.next();
                params.put(keyt, jsonObj.optString(keyt));
            }
        }
        return params;
    }

    public static Map<String, Object> parseJsonToMap(String jsonObjStr) {
        Map<String, Object> map = null;
        try {
            JSONObject jsonObj = JsonUtils.parseJsonObject(jsonObjStr);
            map = JsonUtils.parseJsonToMap(jsonObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static List<Map<String, Object>> parseJsonArrToMapList(JSONArray jsonArr) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        try {
            for (int i = 0; i < jsonArr.length(); ++i) {
                arrayList.add(JsonUtils.parseJsonToMap(jsonArr.getJSONObject(i)));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return arrayList;
    }

    public static List<Map<String, Object>> parseJsonArrToMapList(String jsonArrStr) {
        List<Map<String, Object>> arrayList = null;
        try {
            arrayList = JsonUtils.parseJsonArrToMapList(JsonUtils.parseJsonArray(jsonArrStr));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return arrayList;
    }

    public static JSONObject parseMapToJSONObject(Map<String, Object> map) {
        JSONObject obj = new JSONObject();
        Iterator<String> iter = map.keySet().iterator();
        while (iter.hasNext()) {
            try {
                String key = iter.next();
                obj.put(key, (Object)(map.get(key) != null ? map.get(key).toString() : ""));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return obj;
    }

    public static JSONArray parseListToJSONArray(List<Map<String, Object>> listMap) {
        JSONArray array = new JSONArray();
        for (int i = 0; i < listMap.size(); ++i) {
            Map<String, Object> map = listMap.get(i);
            JSONObject jsonObject = JsonUtils.parseMapToJSONObject(map);
            array.put((Object)jsonObject);
        }
        return array;
    }

    public static void iterateArray(JSONArray array, ArrayIterator iterator) {
        for (int i = 0; i < array.length(); ++i) {
            JSONObject item = array.optJSONObject(i);
            iterator.iterate(i, item);
        }
    }

    public static JSONObject mergeJsonObj(JSONObject newJson, JSONObject oldJson, String filter) {
        try {
            Iterator keys = newJson.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (!TextUtils.isEmpty((CharSequence)filter) && key.contains(filter)) continue;
                oldJson.put(key, newJson.get(key));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return oldJson;
    }

    public static boolean isEmpty(JSONObject json) {
        if (json == null) {
            return true;
        }
        return json.length() == 0;
    }

    public static boolean isEmpty(JSONArray array) {
        if (array == null) {
            return true;
        }
        return array.length() == 0;
    }

    public static interface ArrayIterator {
        public void iterate(int var1, JSONObject var2);
    }
}

