/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Point;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.WindowManager;
import java.math.BigDecimal;

public class DimensionUtils {
    public static final int TABLET_MIN_SIZE = 8;
    private static TypedValue mTmpValue = new TypedValue();

    public static int px2Dip(Context context, int px) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)((float)px / scale + 0.5f * (float)(px >= 0 ? 1 : -1));
    }

    public static int dip2Px(Context context, int dip) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)((float)dip * scale + 0.5f * (float)(dip >= 0 ? 1 : -1));
    }

    public static int getScreenWidth(Context context) {
        return DimensionUtils.getScreenDimen(context, 0);
    }

    public static int getScreenWidth(Context context, int percent) {
        int width = DimensionUtils.getScreenDimen(context, 0);
        return width * percent / 100;
    }

    public static int getScreenHeight(Context context) {
        return DimensionUtils.getScreenDimen(context, 1);
    }

    public static int getScreenHeight(Context context, int percent) {
        int height = DimensionUtils.getScreenDimen(context, 1);
        return height * percent / 100;
    }

    public static int getScreenDimen(Context context, int flag) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        DisplayMetrics metrics = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(metrics);
        if (0 == flag) {
            return metrics.widthPixels;
        }
        return metrics.heightPixels;
    }

    public static boolean isLargeTablet(Context context) {
        return DimensionUtils.getScreenSize(context) >= 8.0;
    }

    public static double getScreenSize(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        DisplayMetrics metrics = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(metrics);
        double diagonalPixels = Math.sqrt(Math.pow(metrics.widthPixels, 2.0) + Math.pow(metrics.heightPixels, 2.0));
        return diagonalPixels / (double)(metrics.density * (float)metrics.densityDpi);
    }

    public static boolean isTablet(Context context) {
        return (context.getResources().getConfiguration().screenLayout & 0xF) >= 3;
    }

    public static int getOrientation(Context context) {
        int w = DimensionUtils.getScreenWidth(context);
        int h = DimensionUtils.getScreenHeight(context);
        int orientation = 0;
        orientation = w < h ? 1 : 2;
        return orientation;
    }

    public static boolean isScreenPortait(Context context) {
        int portaitFlag;
        int orientationFlag = DimensionUtils.getOrientation(context);
        return orientationFlag == (portaitFlag = 1);
    }

    public static boolean isScreenLandscape(Context context) {
        int LandscapeFlag;
        int orientationFlag = DimensionUtils.getOrientation(context);
        return orientationFlag == (LandscapeFlag = 2);
    }

    public static int getStatusBarHeight(Context context) {
        int result = 0;
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = context.getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }

    public static int sp2px(Context context, int dimen) {
        int spValue = DimensionUtils.getXmlDef(context, dimen);
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)((float)spValue * fontScale + 0.5f);
    }

    @SuppressLint(value={"NewApi"})
    public static double getScreenPhysicalInch(Context context) {
        Point point = new Point();
        WindowManager wm = (WindowManager)context.getSystemService("window");
        if (Build.VERSION.SDK_INT >= 17) {
            wm.getDefaultDisplay().getRealSize(point);
        } else {
            wm.getDefaultDisplay().getSize(point);
        }
        DisplayMetrics dm = context.getResources().getDisplayMetrics();
        double x2 = Math.pow((float)point.x / dm.xdpi, 2.0);
        double y = Math.pow((float)point.y / dm.ydpi, 2.0);
        double screenInches = Math.sqrt(x2 + y);
        BigDecimal bd = new BigDecimal(screenInches);
        return bd.setScale(1, 4).doubleValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getXmlDef(Context context, int id2) {
        TypedValue typedValue = mTmpValue;
        synchronized (typedValue) {
            TypedValue value = mTmpValue;
            context.getResources().getValue(id2, value, true);
            return (int)TypedValue.complexToFloat((int)value.data);
        }
    }

    public static int getDimen(Context context, int dimenId) {
        return (int)context.getResources().getDimension(dimenId);
    }
}

