/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.dialog;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.widget.CheckBox;
import android.widget.TextView;
import com.szboanda.android.platform.R;
import com.szboanda.android.platform.view.UniversalAdapter;
import java.util.ArrayList;
import java.util.List;

public abstract class SelectItemAdapter<T>
extends UniversalAdapter<T> {
    private List<Boolean> mCheckStates = new ArrayList<Boolean>();
    private List<T> mFiltedData = null;
    private List<T> mOriginalData = new ArrayList<T>();
    protected boolean isSingleCheck = false;

    public SelectItemAdapter(Context context) {
        super(context, null, R.layout.platform_singleline_select_item);
        this.mData = new ArrayList();
        this.initData(0);
    }

    public SelectItemAdapter(Context context, boolean isSingleCheck) {
        this(context);
        this.isSingleCheck = isSingleCheck;
    }

    void initData(int groupIndex) {
        this.mData.clear();
        this.mData.addAll(this.getDataAtGroupPosition(groupIndex));
        this.mOriginalData.clear();
        this.mOriginalData.addAll(this.mData);
        this.refreshCheckStates();
    }

    public boolean isSingleCheck() {
        return this.isSingleCheck;
    }

    public void setSingleCheck(boolean isSingleCheck) {
        this.isSingleCheck = isSingleCheck;
    }

    @Override
    public void bindViewsData(int position, View convertView, T itemData) {
        CheckBox cb = (CheckBox)convertView.findViewById(R.id.multi_check_btn);
        cb.setChecked(this.mCheckStates.get(position).booleanValue());
        cb.setVisibility(this.isSingleCheck ? 4 : 0);
        TextView txtTitle = (TextView)convertView.findViewById(R.id.item_name);
        this.bindItemTitle(txtTitle, itemData);
    }

    public void onSingleItemCheck(int position) {
        ArrayList singleCheckItem = new ArrayList();
        singleCheckItem.add(this.mData.get(position));
        this.onItemChecked(position, singleCheckItem);
    }

    public void onMultiItemCheck(int position) {
        this.mCheckStates.set(position, this.mCheckStates.get(position) == false);
        this.notifyDataSetChanged();
    }

    public void onPositiveBtnClick() {
        ArrayList checkItems = new ArrayList();
        int index = 0;
        for (boolean isChecked : this.mCheckStates) {
            if (isChecked) {
                checkItems.add(this.mData.get(index));
            }
            ++index;
        }
        this.onItemChecked(-1, checkItems);
    }

    public void filteWithKeyword(String keyword) {
        this.mData.clear();
        if (!TextUtils.isEmpty((CharSequence)keyword)) {
            if (this.mFiltedData == null) {
                this.mFiltedData = new ArrayList<T>();
            }
            this.mFiltedData.clear();
            for (T item : this.mOriginalData) {
                if (!this.isItemMatchKeyword(keyword, item)) continue;
                this.mFiltedData.add(item);
            }
            this.mData.addAll(this.mFiltedData);
        } else {
            this.mData.addAll(this.mOriginalData);
        }
        this.refreshCheckStates();
        this.notifyDataSetChanged();
    }

    private void refreshCheckStates() {
        this.mCheckStates.clear();
        for (int i = 0; i < this.mData.size(); ++i) {
            this.mCheckStates.add(false);
        }
    }

    public void onGroupSelectChange(int groupIndex) {
        this.initData(groupIndex);
        this.notifyDataSetChanged();
    }

    public abstract void bindItemTitle(TextView var1, T var2);

    public abstract String[] getGroupTitles();

    public abstract List<T> getDataAtGroupPosition(int var1);

    public abstract void onItemChecked(int var1, List<T> var2);

    public boolean isItemMatchKeyword(String keyword, T itemData) {
        return false;
    }
}

