/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.dialog;

import android.app.AlertDialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.szboanda.android.platform.dialog.ViewDialog;
import com.szboanda.android.platform.http.impl.IProgressChangeView;
import com.szboanda.android.platform.util.BeanUtil;
import com.szboanda.android.platform.util.DimensionUtils;

public class PercentProgressDiaog
extends ViewDialog
implements IProgressChangeView {
    private Context mContext;
    private ProgressBar mProgressBar;
    private TextView mProgressPercent;
    public AlertDialog mDialog;
    private String mTitle;
    private double mProgressMax = Double.MAX_VALUE;
    private double mProgress = 0.0;

    public PercentProgressDiaog(Context context, String title) {
        super(context);
        this.mContext = context;
        this.mTitle = title;
        this.buildDialog();
        this.clickWithDismiss = false;
    }

    private void buildDialog() {
        this.setTitle(this.mTitle);
        RelativeLayout container = new RelativeLayout(this.mContext);
        this.mProgressBar = new ProgressBar(this.mContext);
        this.mProgressBar.setMax((int)this.mProgressMax);
        this.mProgressBar.setProgress((int)this.mProgress);
        this.mProgressBar.setId("progress".hashCode());
        BeanUtil.setFieldValue((Object)this.mProgressBar, "mOnlyIndeterminate", (Object)false);
        this.mProgressBar.setIndeterminate(false);
        LayerDrawable layerDrawable = (LayerDrawable)this.mContext.getResources().getDrawable(17301612);
        ClipDrawable clipDrawable = (ClipDrawable)layerDrawable.getDrawable(2);
        clipDrawable.setColorFilter(Color.parseColor((String)"#32B5E5"), PorterDuff.Mode.SRC_IN);
        this.mProgressBar.setProgressDrawable((Drawable)layerDrawable);
        this.mProgressBar.setPadding(0, 0, 0, 0);
        this.mProgressBar.setIndeterminateDrawable(this.mContext.getResources().getDrawable(17301613));
        this.mProgressPercent = new TextView(this.mContext);
        this.mProgressPercent.setId("percent".hashCode());
        this.mProgressPercent.setText((CharSequence)"0%");
        this.mProgressPercent.setTextSize(18.0f);
        int lrPadding = DimensionUtils.dip2Px(this.mContext, 10);
        int tbPadding = DimensionUtils.dip2Px(this.mContext, 30);
        container.setPadding(lrPadding, tbPadding, lrPadding, tbPadding);
        RelativeLayout.LayoutParams progressLayoutParams = new RelativeLayout.LayoutParams(-1, DimensionUtils.dip2Px(this.mContext, 4));
        progressLayoutParams.addRule(15);
        progressLayoutParams.addRule(0, this.mProgressPercent.getId());
        progressLayoutParams.rightMargin = lrPadding;
        this.mProgressBar.setLayoutParams((ViewGroup.LayoutParams)progressLayoutParams);
        RelativeLayout.LayoutParams percentLayoutParams = new RelativeLayout.LayoutParams(-2, -2);
        percentLayoutParams.addRule(11);
        percentLayoutParams.addRule(15);
        this.mProgressPercent.setLayoutParams((ViewGroup.LayoutParams)percentLayoutParams);
        container.addView((View)this.mProgressPercent);
        container.addView((View)this.mProgressBar);
        this.setView((View)container);
    }

    public void setProgress(int progress) {
        this.mProgress = progress;
        this.mProgressBar.setProgress(progress);
        this.mProgressPercent.setText((CharSequence)((int)(this.mProgress / this.mProgressMax * 100.0) + "%"));
    }

    @Override
    public void initProgressMax(long progressMax) {
        this.mProgressMax = Double.parseDouble(progressMax + "");
        this.mProgressBar.setMax((int)progressMax);
    }

    @Override
    public void onProgressChanged(long total, final long current, int ratio) {
        try {
            this.setProgress((int)current);
        }
        catch (Exception e) {
            this.mProgressBar.post(new Runnable(){

                @Override
                public void run() {
                    PercentProgressDiaog.this.setProgress((int)current);
                }
            });
        }
    }

    @Override
    public void onFinish() {
        this.dismiss();
    }
}

