/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.db;

import android.content.Context;
import android.util.Log;
import com.szboanda.android.platform.db.DbHelper;
import com.szboanda.android.platform.util.ResourceUtils;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.xutils.DbManager;
import org.xutils.db.DbManagerImpl;
import org.xutils.db.table.TableEntity;

public class SQLiteUpgradeListener
implements DbManager.DbUpgradeListener {
    private static final String TAG = "SQLiteUpgradeListener";
    private String mDbName;
    private Context mContext;
    private static final String SYMBOL_DROP_TABLE = "_upgrade_drop_table_";
    private static final String SYMBOL_ADD_COLUMN = "_upgrade_add_col_";
    private static final String SYMBOL_SQL = "_upgrade_sql_";
    private DbManager mDbManager;

    public SQLiteUpgradeListener(Context context, String dbName) {
        this.mContext = context;
        this.mDbName = dbName;
    }

    public void onUpgrade(DbManager db, int oldVersion, int newVersion) {
        this.upgradeDbByConfig(oldVersion, newVersion);
    }

    public void upgradeDbByConfig(int oldVersion, int newVersion) {
        int start;
        for (int i = start = oldVersion + 1; i <= newVersion; ++i) {
            this.dropTable(i);
            this.addColumn(i);
            this.exeUpgradeSqls(i);
        }
    }

    private void addColumn(int versionCode) {
        String prefix = this.mDbName.replace(".db", "") + SYMBOL_ADD_COLUMN + versionCode + "_";
        List<Integer> ids = ResourceUtils.findResIdsByNamePrefix(this.mContext, prefix, ResourceUtils.ResoureType.ARRAY);
        String packName = this.mContext.getPackageName();
        for (Integer id2 : ids) {
            String[] columns = this.mContext.getResources().getStringArray(id2.intValue());
            String name = this.mContext.getResources().getResourceName(id2.intValue());
            String tableName = name.replace(packName + ":array/", "").replace(prefix, "");
            if (!DbHelper.isTableExist(name)) continue;
            for (String value : columns) {
                String colName = value.toUpperCase(Locale.getDefault());
                String type = "TEXT";
                if (value.contains("#")) {
                    colName = value.split("#")[0];
                    type = value.split("#")[1];
                }
                String sql = "ALTER TABLE " + tableName + " ADD " + colName + " " + type;
                try {
                    this.mDbManager.execNonQuery(sql);
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("Execute add column sql '" + sql + "' error"));
                    e.printStackTrace();
                }
            }
        }
    }

    private void exeUpgradeSqls(int versionCode) {
        String prefix = this.mDbName.replace(".db", "") + SYMBOL_SQL + versionCode;
        int id2 = ResourceUtils.findResId(this.mContext, prefix, ResourceUtils.ResoureType.ARRAY);
        if (id2 != 0) {
            String[] sqls = this.mContext.getResources().getStringArray(id2);
            this.mDbManager.getDaoConfig().setAllowTransaction(true);
            for (String sql : sqls) {
                try {
                    this.mDbManager.execNonQuery(sql);
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("Execute upgrade sql '" + sql + "' error"));
                    e.printStackTrace();
                }
            }
        }
    }

    private void dropTable(int versionCode) {
        int configId = this.findDropTable(versionCode);
        if (configId != 0) {
            String[] tables;
            for (String name : tables = this.mContext.getResources().getStringArray(configId)) {
                if (!DbHelper.isTableExist(name)) continue;
                try {
                    this.mDbManager.execNonQuery("DROP TABLE " + name);
                    Field tablesField = DbManagerImpl.class.getField("tableMap");
                    tablesField.setAccessible(true);
                    HashMap tablesCache = (HashMap)tablesField.get(this.mDbManager);
                    if (tablesCache == null) continue;
                    Set tes = tablesCache.keySet();
                    for (Class cls : tes) {
                        TableEntity te = (TableEntity)tablesCache.get(cls);
                        if (!name.equalsIgnoreCase(te.getName())) continue;
                        tablesCache.remove(cls);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private int findDropTable(int versionCode) {
        String name = this.mDbName.replace(".db", "") + SYMBOL_DROP_TABLE + versionCode;
        int dropTableArrayId = ResourceUtils.findResId(this.mContext, name, ResourceUtils.ResoureType.ARRAY);
        return dropTableArrayId;
    }
}

