package com.szboanda.android.platform.widget;

import java.util.Calendar;

import com.szboanda.android.platform.R;
import com.szboanda.android.platform.widget.DateTimePicker.PickerOptions;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.text.format.DateUtils;
import android.view.Gravity;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.WindowManager.LayoutParams;
import android.widget.RelativeLayout;
import android.widget.TextView;
 
public class DateTimePickerDialog extends Dialog implements
        OnClickListener {

    private OnDateTimeSetListener mOnDateTimeSetListener;
    private Calendar mDate = Calendar.getInstance();
    

    public DateTimePickerDialog(Context context){
    	this(context, null);
    }
    
    public DateTimePickerDialog(Context context, DateTimePicker.PickerOptions opts){
        super(context, R.style.WidgetDialog);
        setContentView(buildContentView(context, opts));
        LayoutParams params = getWindow().getAttributes();
        params.gravity = Gravity.BOTTOM;
        params.width = LayoutParams.MATCH_PARENT;
    }
    
    private View buildContentView(Context context, PickerOptions opts) {
    	int px = dip2Px(context, 10);
		RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT,
				RelativeLayout.LayoutParams.WRAP_CONTENT);
    	RelativeLayout root = new RelativeLayout(context);
    	root.setBackgroundColor(Color.WHITE);
    	root.setLayoutParams(params);
    	root.setPadding(px, px, px, px);
    	
    	TextView cancel = new TextView(context);
    	cancel.setId(android.R.id.button1);
    	cancel.setPadding(px, px, px, px);
    	cancel.setClickable(true);
    	cancel.setTextSize(16);
    	cancel.setTextColor(context.getResources().getColor(R.color.cancel_text_color));
    	cancel.setText(context.getResources().getString(R.string.cancel));
    	RelativeLayout.LayoutParams paramsc = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT,
				RelativeLayout.LayoutParams.WRAP_CONTENT);
    	paramsc.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
    	paramsc.addRule(RelativeLayout.ALIGN_PARENT_TOP);
    	root.addView(cancel, paramsc);
    	
    	TextView ok = new TextView(context);
    	ok.setId(android.R.id.button2);
    	ok.setPadding(px, px, px, px);
    	ok.setClickable(true);
    	ok.setTextSize(16);
    	ok.setTextColor(context.getResources().getColor(R.color.ok_text_color));
    	ok.setText(context.getResources().getString(R.string.ok));
    	RelativeLayout.LayoutParams paramso = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT,
				RelativeLayout.LayoutParams.WRAP_CONTENT);
    	paramso.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
    	paramso.addRule(RelativeLayout.ALIGN_PARENT_TOP);
    	root.addView(ok, paramso);
    	
    	DateTimePicker picker = new DateTimePicker(context, opts);
    	RelativeLayout.LayoutParams paramsp = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT,
				RelativeLayout.LayoutParams.WRAP_CONTENT);
    	paramsp.addRule(RelativeLayout.CENTER_IN_PARENT);
    	paramsp.addRule(RelativeLayout.BELOW, android.R.id.button1);
    	root.addView(picker, paramsp);
    	
    	cancel.setOnClickListener(this);
    	ok.setOnClickListener(this);
    	picker.setOnDateTimeChangedListener(new DateTimePicker.OnDateTimeChangedListener() {
            @Override
            public void onDateTimeChanged(DateTimePicker view,
                    int year, int month, int day, int hour, int minute) {
                mDate.set(Calendar.YEAR, year);
                mDate.set(Calendar.MONTH, month);
                mDate.set(Calendar.DAY_OF_MONTH, day);
                mDate.set(Calendar.HOUR_OF_DAY, hour);
                mDate.set(Calendar.MINUTE, minute);
                mDate.set(Calendar.SECOND, 0);
            }
        });
    	
    	return root;
    }
    
    private int dip2Px(Context context, int dip) {
		float scale = context.getResources().getDisplayMetrics().density;
		return (int) (dip * scale + 0.5f * (dip >= 0 ? 1 : -1));
	}
    

    @Override
    public void onClick(View v) {
    	if(v.getId() == android.R.id.button1){
    		dismiss();
    	}else if(v.getId() == android.R.id.button2){
    		dismiss();
    		if (mOnDateTimeSetListener != null) {
    			mOnDateTimeSetListener.OnDateTimeSet(this, mDate.getTimeInMillis());
    		}
    	}
    	
    }
    
    public String getDateDescription(){
    	int flag = DateUtils.FORMAT_SHOW_YEAR | DateUtils.FORMAT_SHOW_DATE
    			| DateUtils.FORMAT_SHOW_WEEKDAY | DateUtils.FORMAT_SHOW_TIME;
    	return DateUtils.formatDateTime(getContext(), mDate.getTimeInMillis(), flag);
    }
    
    /*
     * 对外公开方法让Activity实现
     */
    public void setOnDateTimeSetListener(OnDateTimeSetListener callBack) {
    	mOnDateTimeSetListener = callBack;
    }
    
    /**
     *日期时间设置回调
     */
    public interface OnDateTimeSetListener {
        void OnDateTimeSet(Dialog dialog, long date);
    }
    
 
}