package com.szboanda.android.platform.view;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.json.JSONObject;

import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;


/**
 * <p>Description: 自定义视图绑定值类</p>
 * @Company    深圳市博安达软件开发有限公司
 * @author    Siyi Lu    Create Date: 2014-9-22
 * @modify   Siyi Lu    2014-9-22    
 */
public class CustomViewBinder {
	
	public static final String NAMESPACE = "http://schemas.android.com/apk/res/";
	public static final String NAMESPACE_AUTO = "http://schemas.android.com/apk/res-auto";
	
	/**直接指定根视图*/
	private View rootView;
	
	/**必填验证*/
	private Map<String, String> notEmptyMsgs = new LinkedHashMap<String, String>();
	
	/**记录值为空，但是配置为不允许为空的视图*/
	private List<View> valueIsEmptyViews = new ArrayList<View>();
	
	public CustomViewBinder(){}
	
	public CustomViewBinder(View rootView){
		this.rootView = rootView;
	}
	
	public void recursiveFetchJson(JSONObject result){
		clearNotEmptyMsg();
		recursiveFetchJson(rootView, result);
	}
	
	public void recursiveFetchJson(View v, JSONObject result){
		recursiveFetchJson(v, result, null);
	}
	
	public void recursiveFetchJson(View v, JSONObject result, IKeyConvertor convertor){
		if(v instanceof ViewGroup){
			ViewGroup curGroup = (ViewGroup)v;
			for(int i=0; i<curGroup.getChildCount(); i++){
				View forView = curGroup.getChildAt(i);
				if(forView instanceof IBindableView){
					IBindableView customView = (IBindableView)forView;
					BindableViewHandler bindHandler = customView.getBindHandler();
					bindHandler.setKeyConvert(convertor);
					String notEmptyMsg = bindHandler.appendValue(result);
					if(!TextUtils.isEmpty(notEmptyMsg)){
						String key = bindHandler.getField();
						if(!TextUtils.isEmpty(key)){
							notEmptyMsgs.put(key, notEmptyMsg);
							valueIsEmptyViews.add(forView);
						}
					}
				}else if(forView instanceof ViewGroup){
					recursiveFetchJson(forView, result, convertor);
				}
			}
		}
	}
	
	public void recursiveBindData(JSONObject json, boolean isEnable){
		recursiveBindData(rootView, json, isEnable);
	}
	
	public void recursiveBindData(View vg, JSONObject json, boolean isEnable){
		recursiveBindData(vg, json, isEnable, null);
	}
	
	public void recursiveBindData(View vg, JSONObject json, boolean isEnable, IKeyConvertor convertor){
		if(vg instanceof ViewGroup){
			ViewGroup curGroup = (ViewGroup)vg;
			for(int i=0; i<curGroup.getChildCount(); i++){
				View cv = curGroup.getChildAt(i);
				if(cv instanceof IBindableView){
					IBindableView customView = (IBindableView)cv;
					BindableViewHandler bindHandler = customView.getBindHandler();
					bindHandler.setKeyConvert(convertor);
					bindHandler.bindValue(json, isEnable);
				}else if(cv instanceof ViewGroup){
					recursiveBindData(cv, json, isEnable, convertor);
				}
			}
		}
	}
	
	public void clearNotEmptyMsg(){
		notEmptyMsgs.clear();
		valueIsEmptyViews.clear();
	}
	
	public String getNotEmptyMsg(){
		String result = "";
		if(notEmptyMsgs.size()>0){
			Set<String> keys = notEmptyMsgs.keySet();
			for(String k:keys){
				String v = notEmptyMsgs.get(k);
				result += "\n" + v;
			}
		}
		if(result.startsWith("\n")){
			result = result.substring(1);
		}
		return result;
	}
	
	public List<View> getValueIsEmptyViews(){
		return valueIsEmptyViews;
	}
	
	public interface IKeyConvertor{
		String convertKey(IKeyConvertable target);
	}
	
	public interface IKeyConvertable{
		String acceptConvert(IKeyConvertor convertor);
	}
	
}
