package com.szboanda.android.platform.view;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.View;
import android.widget.CompoundButton;
import android.widget.RadioButton;

import com.szboanda.android.platform.R;

/**
 * 自定义RadioButton
 * @author Siyi Lu
 */
public class BindableRadioButton extends RadioButton implements IBindableView{
	
	private BindableViewHandler mBindHandler;
	
	/**按钮选中时定义的值*/
	private String checkedValue;
	/**绑定显示的视图*/
	private int radioViewId;

	public BindableRadioButton(Context context, AttributeSet attrs, int defStyle) {
		super(context, attrs, defStyle);
	}

	public BindableRadioButton(Context context, AttributeSet attrs) {
		super(context, attrs);
		mBindHandler = new BindableViewHandler(this);
		mBindHandler.initWithTypedArray(getResources(), attrs);
		TypedArray ta = getResources().obtainAttributes(attrs, R.styleable.BindableRadioButton);
		checkedValue = ta.getString(R.styleable.BindableRadioButton_checkedValue);
		if(TextUtils.isEmpty(checkedValue)){
			checkedValue = getText().toString();
		}
		ta.recycle();
		bindViewListener();
	}

	public BindableRadioButton(Context context) {
		super(context); 
		mBindHandler = new BindableViewHandler(this);
		setGravity(Gravity.CENTER_VERTICAL);
	}
	
	public void setField(String dbField){
		mBindHandler.setField(dbField);
	}
	
	public int getRadioViewId(){
		return radioViewId;
	}
	
	public void setFieldValue(String fieldValue){
		this.checkedValue = fieldValue;
	}
	
	public String getFieldValue(){
		String value = "";
		if(isChecked()){
			value = checkedValue;
		}
		return value;
	}
	
	/**
	 * 在配置了受按钮控制的视图ID情况下，绑定监听事件，处理视图的显示与否
	 */
	private void bindViewListener(){
		if(radioViewId != -1){
			setOnCheckedChangeListener(new OnCheckedChangeListener() {
				@Override
				public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
					View view = ((Activity)getContext()).findViewById(radioViewId);
					if(view != null){
						view.setVisibility(isChecked ? View.VISIBLE : View.GONE);
					}
				}
			});
		}
	}

	@Override
	public void setEmptyMsg(String notEmptyTipMsg) {
		mBindHandler.setNotEmptyMsg(notEmptyTipMsg);
	}

	@Override
	public void setBindValue(String value) {
		setChecked(checkedValue.equals(value));
	}

	@Override
	public String getBindValue() {
		return isChecked() ? checkedValue : "";
	}

	@Override
	public BindableViewHandler getBindHandler() {
		return mBindHandler;
	}
	
	


}
