package com.szboanda.android.platform.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import android.app.Service;
import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.telephony.TelephonyManager;

/**
 * <p>Description:Noinstantiable utility class </p>
 * @Company    深圳市博安达软件开发有限公司
 * @author    Siyi Lu    Create Date: 2015-1-6
 * @modify  
 */
public class MobileInfo {
	
	private MobileInfo(Context context){
		//起到类不会被实例化的作用
	}
	
	/**
	 * 获取手机型号，如note3
	 * @return
	 */
	public final static int getPhoneType(Context context){
		TelephonyManager mTelephony = (TelephonyManager)context
			.getSystemService(Service.TELEPHONY_SERVICE);
		return  mTelephony.getPhoneType();
	}
	
	/**
	 * 获取SIM卡的国际识别码
	 * @return
	 */
	public final static String getImsiCode(Context context){
		TelephonyManager mTelephony = (TelephonyManager)context
			.getSystemService(Service.TELEPHONY_SERVICE);
		String imsiCode = null;
		imsiCode = mTelephony.getSubscriberId();
		return imsiCode;
	}
	
	/**
	 * 获取设备的全球唯一标识码
	 * @return
	 */
	public final static String getImeiCode(Context context){
		TelephonyManager mTelephony = (TelephonyManager)context
				.getSystemService(Service.TELEPHONY_SERVICE);
		String imeiCode = mTelephony.getDeviceId();
		if(imeiCode != null){
			return imeiCode;
		}else{
			return getMacCode(context);
		}
	}
	
	/**
	 * 获取设备的网卡Mac地址
	 * @return
	 */
	public final static String getMacCode(Context context){
		WifiManager mWifiManager = (WifiManager)context.getSystemService(Service.WIFI_SERVICE);
		String macCode = null;
		WifiInfo info = mWifiManager.getConnectionInfo();
		if(info != null){
			macCode = info.getMacAddress();
		}
		return macCode;
	}

	/**检验电话号码是否合法
	 * <p>后续根据存在的电话号码继续修改正则表达式</p>*/
	public final static boolean isPhoneNumber(String mobiles){
		Pattern p = Pattern.compile("^(((13[0-9])|(15([0-3]|[5-9]))|(18[0-9])|(177))\\d{8})|(0\\d{2}-\\d{8})|(0\\d{3}-\\d{7})$");
		Matcher m = p.matcher(mobiles);
		return m.matches();
	}
}
