package com.szboanda.android.platform.http.impl;

import android.text.TextUtils;

import com.szboanda.android.platform.http.IDataProtocol;
import com.szboanda.android.platform.util.BeanUtil;
import com.szboanda.android.platform.util.JsonUtils;

import org.json.JSONObject;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

/**
 * <p>Description：</p>
 *
 * @author Created by Siyi Lu on 2017/2/28.
 * @Company 深圳市博安达信息技术股份有限公司
 */

public class EntityProtocol implements IDataProtocol {

    private String mDataKey = null;

    @Override
    public void dataKey(String key) {
        mDataKey = key;
    }

    @Override
    public <E> E convert(String result, Type type) {
        if (TextUtils.isEmpty(mDataKey)){
            return BeanUtil.convertJsonStr2Entity(result, type);
        }else{
            JSONObject resultJson = JsonUtils.parseJsonObject(result);
            return BeanUtil.convertJsonStr2Entity(resultJson.optString(mDataKey), type);
        }
    }
}
