package com.szboanda.android.platform.http;

import android.app.Dialog;
import android.content.Context;

import com.szboanda.android.platform.dialog.PercentNotification;
import com.szboanda.android.platform.http.impl.IProgressChangeView;
import com.szboanda.android.platform.util.JsonUtils;

import org.json.JSONObject;
import org.xutils.common.Callback;

public abstract class UploadResponseProcessor<T>
	extends ResponseProcessor<T> implements Callback.ProgressCallback<String>{
	
	private IProgressChangeView mChangeView;

    private boolean isBackgroundUpload = false;

    private PercentNotification mNotice = null;

    private String mTitle;

    public void setTitle(String title) {
        this.mTitle = title;
    }

    public void setBackgroundUpload(boolean backgroundUpload) {
        this.isBackgroundUpload = backgroundUpload;
    }

    @Override
	public void onSuccess(String responseInfo) {
        super.onSuccess(responseInfo);
		if(mChangeView != null) {
            mChangeView.onFinish();
        }
	}

    @Override
	public void onLoading(long total, long current, boolean isUploading) {
        if(isBackgroundUpload){
            noticeUpload(total, current, isUploading);
            if (mChangeView != null && mChangeView instanceof Dialog){
                if(((Dialog) mChangeView).isShowing()) {
                    ((Dialog) mChangeView).dismiss();
                }
                return;
            }
        }
		int ratio = (int)(Double.valueOf(current + "")/Double.valueOf(total + "")*100);
		if(mChangeView != null){
			mChangeView.onProgressChanged(total, current, ratio);
		}
	}

	private void noticeUpload(long total, long current, boolean isUploading){
        if(mNotice == null){
            mNotice = new PercentNotification(getContext())
                    .title(mTitle)
                    .total(total)
                    .current(current);
        }
        mNotice.current(current);
        mNotice.notice();
    }

    @Override
    public void onWaiting() {

    }

    @Override
    public void onStarted() {

    }

    public IProgressChangeView getChangeView() {
		return mChangeView;
	}

	public void setChangeView(IProgressChangeView changeView) {
		this.mChangeView = changeView;
	}
	
	
	

}
