package com.szboanda.android.platform.http;

import android.app.Dialog;
import android.content.Context;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;

import com.szboanda.android.platform.UniversalAsyncTask;
import com.szboanda.android.platform.dialog.BaseDialog.OnDialogButtonClickListener;
import com.szboanda.android.platform.dialog.CustomProgressDialog;
import com.szboanda.android.platform.dialog.PercentProgressDiaog;
import com.szboanda.android.platform.http.impl.IProgressChangeView;
import com.szboanda.android.platform.http.impl.ResponseStream;

import org.xutils.HttpManager;
import org.xutils.common.Callback;
import org.xutils.x;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * <p>Description:网络请求任务 </p>
 * <p></p>
 * @Company    深圳市博安达信息技术股份有限公司
 * @author    Siyi Lu    Create Date: 2015-7-20
 * @modify  
 */
public class HttpTask {
	
	/**网络响应超时默认值*/
	private static final int TIME_OUT_DEFAULT = 5*1000; 
	
	private int mTimeOut = 0;
	
	private HttpManager mHttpManager;
	
	private Context mContext;
	
	private CustomProgressDialog mDialog;
	
	private boolean showProgressDiallog;
	
	private String tipMsg = "正在请求数据...";
	
	public static final String TEMP_DOWNLOAD_FILE_SUFFIX = ".dltemp";

    private Callback.Cancelable mCanceler = null;
	
	public HttpTask(){
		this(null, null);
	}
	
	/**
	 * 默认不显示等待提示对话框
	 * @param context
	 */
	public HttpTask(Context context){
		this(context , null);
	}
	
	/**
	 * 默认显示等待提示对话框
	 * @param context
	 * @param tipMsg 等待提示框提示内容
	 */
	public HttpTask(Context context, String tipMsg){
		mContext = context;
		this.tipMsg = tipMsg;
		showProgressDiallog = !TextUtils.isEmpty(tipMsg);
		mHttpManager = x.http();
    }
	
	public void setTimeOut(int timeout){
		mTimeOut = timeout;
	}
	
	public HttpManager getHttpProxy(){
		return mHttpManager;
	}
	
	/**
	 * 网络请求前准备
	 */
	private void onPreInvoke(){
		if(mContext != null&& showProgressDiallog && mDialog == null){
			mDialog = new CustomProgressDialog(mContext);
			mDialog.setMessage(tipMsg);
			mDialog.show();
		}
	}
	
	/**
	 * 发起网络数据请求, 显示默认的等待对话框{@link CustomProgressDialog}
	 * @param params
	 * @param processer
	 */
	@SuppressWarnings("rawtypes")
	public void executePost(ParamsWrapper params, ResponseProcessor processer){
		executePost(params, true, processer);
	}
	
	/**
	 * 发起网络数据请求, 显示默认的等待对话框{@link CustomProgressDialog}
	 * @param params
	 * @param processer
	 */
	@SuppressWarnings("rawtypes")
	public void executeGet(ParamsWrapper params, ResponseProcessor processer){
		executeGet(params, true, processer);
	}
	
	/**
	 * 发起网络数据请求
	 * @param params
	 * @param processer
	 * @param showProgress 是否显示默认的等待对话框{@link CustomProgressDialog}
	 */
	@SuppressWarnings({"rawtypes"})
	public void executePost(ParamsWrapper params, boolean showProgress
			,ResponseProcessor processer){
		execute("POST", params, showProgress, processer);
	}
	
	/**
	 * 发起网络数据请求
	 * @param params
	 * @param processer
	 * @param showProgress 是否显示默认的等待对话框{@link CustomProgressDialog}
	 */
	@SuppressWarnings({"rawtypes"})
	public void executeGet(ParamsWrapper params, boolean showProgress
			,ResponseProcessor processer){
		execute("GET", params, showProgress, processer);
	}
	
	@SuppressWarnings({"rawtypes", "unchecked" })
	private void execute(String method, ParamsWrapper params, boolean showProgress
			,ResponseProcessor processer){
        params.setConnectTimeout(mTimeOut == 0 ? TIME_OUT_DEFAULT : mTimeOut);
		showProgressDiallog = showProgress && !TextUtils.isEmpty(tipMsg);
		onPreInvoke();
		if(showProgress && mDialog != null){
			((ResponseProcessor)processer).setProgressDialog(mDialog);
		}
		if(mContext != null){
			((ResponseProcessor)processer).setContext(mContext);
		}
        if("GET".equalsIgnoreCase(method)){
            mCanceler = mHttpManager.get(params.getRequestParams(), processer);
        }else{
            mCanceler = mHttpManager.post(params.getRequestParams(), processer);
        }
	}
	
	/**下载文件进度提示对话框*/
	private PercentProgressDiaog mPercentDiaog;

	private DownloadResponseProcessor mDownloadProcessor;
	
	/**
	 * 下载文件
	 * @param targetPath 指定的文件存储路径(包含文件名称)
	 * @param params 请求参数
	 * @param processor 下载成功后回调
	 */
	public void downloadFile(String targetPath, ParamsWrapper params, DownloadResponseProcessor processor){
		if(showProgressDiallog){
			mPercentDiaog = new PercentProgressDiaog(mContext, "下载文件");
			setOnClickListener();
		}
		downloadFile(targetPath, params, mPercentDiaog, processor);
	}
	
	/**
	 * 
	 * @param targetPath 指定的文件存储路径(包含文件名称)
	 * @param params 请求参数
	 * @param progressView 实现了{@link IProgressChangeView}接口的视图
	 * @param processor 下载成功后回调
	 */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public void downloadFile(String targetPath, ParamsWrapper params
			,IProgressChangeView progressView, DownloadResponseProcessor processor){
        params.setConnectTimeout(mTimeOut == 0 ? TIME_OUT_DEFAULT : mTimeOut);
        params.setAutoRename(processor.isAutoRename());
        params.setAutoResume(true);
        mDownloadProcessor = processor;
		mDownloadProcessor.setTargetPath(targetPath);
		mDownloadProcessor.setContext(mContext);
		if(processor == null){
			Log.i("HttpTask#downloadFile", "参数【DownloadResponseProcessor】不应为null");
			return;
		}else{
			processor.setProgressView(progressView);
		}
		//检测目标地址是否添加sdcard路径，如果没有主动补全
		String sdcardPath = Environment.getExternalStorageDirectory().getAbsolutePath() + "/";
		if(!targetPath.startsWith(sdcardPath)){
			targetPath = sdcardPath + targetPath;
		}
		if(new File(targetPath).exists()){
			processor.onDownloadSuccess(new File(targetPath));
		}else{
			if(showProgressDiallog){
				mPercentDiaog.show();
			}
			String tempSavePath = createDownloadPath(targetPath);
            params.setSaveFilePath(tempSavePath);
            mCanceler = mHttpManager.post(params.getRequestParams(), processor);
		}
	}
	
	/**
	 * 创建下载文件临时文件路径.为避免重复下载，未下载完成文件统一使用
	 * ".dltemp"为后缀的文件名保存
	 * @param targetPath 指定的文件存储路径(包含文件名称)
	 * @return 替换了文件后缀为{@link HttpTask#TEMP_DOWNLOAD_FILE_SUFFIX}的文件路径
	 */
	public static String createDownloadPath(String targetPath){
		int dotIndex = targetPath.lastIndexOf(".");
		String result = targetPath;
		if(dotIndex != -1){
			String pathRemoveSuffix = targetPath.substring(0, dotIndex); 
			result = pathRemoveSuffix + TEMP_DOWNLOAD_FILE_SUFFIX;
		}
		return result;
	}
	
	public void setOnClickListener(){
		mPercentDiaog.setPositiveButton("后台下载", new OnDialogButtonClickListener() {
			@Override
			public void onClick(Dialog dialog, View v) {
				mPercentDiaog.dismiss();
				mDownloadProcessor.setDownloadBackgroud(true);
			}
		});
		
		mPercentDiaog.setNegativeButton("停止下载", new OnDialogButtonClickListener() {
			@Override
			public void onClick(Dialog dialog, View v) {
				if(mCanceler != null && !mCanceler.isCancelled()){
					mCanceler.cancel();
				}
				mPercentDiaog.dismiss();
			}
		});
	}
	
	/**
	 * 上传文件
	 * @param params 请求参数
	 * @param processor 上传成功后的回调处理
	 */
	public void uploadFile(ParamsWrapper params, final ResponseProcessor processor){
		PercentProgressDiaog uploadTipDiaog = new PercentProgressDiaog(mContext, "上传文件");
		uploadTipDiaog.setPositiveButton("后台上传", new OnDialogButtonClickListener() {
			@Override
			public void onClick(Dialog dialog, View v) {
                dialog.dismiss();
				if(processor instanceof UploadResponseProcessor){
                    processor.setContext(mContext);
                    ((UploadResponseProcessor) processor).setTitle("上传文件");
                    ((UploadResponseProcessor) processor).setBackgroundUpload(true);
                }
			}
		}).setNegativeButton("取消上传", new OnDialogButtonClickListener() {
			@Override
			public void onClick(Dialog dialog, View v) {
                dialog.dismiss();
				if(mCanceler != null){
                    mCanceler.cancel();
                }
			}
		});
		uploadTipDiaog.show();
		uploadFile(params, uploadTipDiaog, processor);
	}
	
	/**
	 * 上传文件
	 * @param params 请求参数
	 * @param changeView 实现了{@link IProgressChangeView}接口的视图
	 * @param processor 上传成功后的回调处理
	 */
	@SuppressWarnings({"rawtypes", "unchecked"})
	public void uploadFile(ParamsWrapper params, IProgressChangeView changeView, ResponseProcessor processor){
		if(processor == null){
			Log.i("HttpTask#uploadFile()", "参数【UploadResponseProcessor】不应为null");
			return;
		}else{
			if(changeView != null && processor instanceof UploadResponseProcessor){
                try{
                    changeView.initProgressMax(params.getRequestParams().getRequestBody().getContentLength());
                    ((UploadResponseProcessor)processor).setChangeView(changeView);
                }catch(Exception e){
                    e.printStackTrace();
                }
			}
		}
        params.setMultipart(true);
        mCanceler = mHttpManager.post(params.getRequestParams(), processor);
	}

    public <E> E sendRequest(ParamsWrapper params, Class<E> responseCls){
        E rs = null;
        try{
            rs = mHttpManager.postSync(params.getRequestParams(), responseCls);
        }catch(Throwable e){
            e.printStackTrace();
        }
        return rs;
    }
	
    public void downloadUrlFile(String urlStr, String savePath, final Runnable callback){
        UniversalAsyncTask asyncTask = new UniversalAsyncTask(null) {
            @Override
            protected Object doInBackground(Object... params) {
                return syncDownloadUrlFile(params[0].toString(), params[1].toString());
            }

            @Override
            protected void onPostExecute(Object result) {
                super.onPostExecute(result);
                if((boolean)result && callback != null){
                    callback.run();
                }
            }
        };
        asyncTask.execute(urlStr, savePath);
    }

    private boolean syncDownloadUrlFile(String urlStr, String savePath){
        boolean result = false;
        boolean isConnected = false;
        HttpURLConnection connection = null;
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        try {
            URL url = new URL(urlStr);
            connection = (HttpURLConnection) url.openConnection();
            connection.connect();
            isConnected = true;
            InputStream is = connection.getInputStream();
            if (is != null) {
                bis = new BufferedInputStream(is);
                File saveFile = new File(savePath);
                File dirFile = saveFile.getParentFile();
                if(!dirFile.exists()){
                    dirFile.mkdirs();
                }
                bos = new BufferedOutputStream(new FileOutputStream(saveFile));
                byte[] buffer = new byte[2048];
                boolean readLen = true;
                int len;
                while((len = bis.read(buffer)) != -1) {
                    bos.write(buffer, 0, len);
                }
                result = true;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }finally {
            try {
                if (connection != null && isConnected) {
                    connection.disconnect();
                }
                if(bos != null){
                    bos.close();
                    bis.close();
                }
            }catch (Exception ei){
                ei.printStackTrace();;
            }
        }
        return result;

    }
	
}
