package com.szboanda.android.platform.db;

import android.app.Application;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;

import com.szboanda.android.platform.util.AppInfoHelper;

import org.json.JSONObject;
import org.xutils.DbManager;
import org.xutils.x;

/**
 * <p>Description: 数据库帮助类</p>
 * </br>使用时，在{@link Application#onCreate()}中进行全局上下文的初始化和获取数据库操作的对象，
 * 具体操作数据库的接口还是保持与xUtils中的{@link DbManager}一致
 * @Company    深圳市博安达软件开发有限公司
 * @author    Siyi Lu    Create Date: 2015-4-22
 * @modify  
 */
public class DbHelper{
	
	private static final String TAG = "DbHelper.java";
	
	private static Context mGlobalContext;
	
	private static String mGlobalDbName;

    private static DbManager.DaoConfig mGlobalConfig;
	
	/**
	 * 在{@link Application#onCreate()}中调用，初始化全局的上下文及系统默认的数据库名称
	 * @param application
	 * @param appDbName
	 */
	public static final void initContext(Application application, String appDbName){
        x.Ext.init(application);
        mGlobalContext = application;
		mGlobalDbName = appDbName;
        mGlobalConfig = new DbManager.DaoConfig()
            .setDbName(mGlobalDbName)
            .setDbVersion(AppInfoHelper.getVersionCode(application))
            .setDbUpgradeListener(new SQLiteUpgradeListener(application, appDbName));
	}
	
	/**
	 * 获取到系统默认数据库的操作对象
	 * @return
	 */
	public static final SQLiteDao getDao(){
		return getDao(null);
	}
	
	/**
	 * 获取到指定数据库名的数据库操作对象
	 * @return
	 */
	public synchronized static final SQLiteDao getDao(String dbName){
		if(mGlobalContext == null){
			Log.i(TAG, "You must initialize the global context for DbHelper");
			return null;
		}
		int versionCode = AppInfoHelper.getVersionCode(mGlobalContext);
		DbManager.DbUpgradeListener listener = new SQLiteUpgradeListener(mGlobalContext
				,TextUtils.isEmpty(dbName) ? mGlobalDbName:dbName);
        if(mGlobalConfig == null){
            mGlobalConfig = new DbManager.DaoConfig()
                .setDbName(mGlobalDbName)
                .setDbVersion(AppInfoHelper.getVersionCode(mGlobalContext))
                .setDbUpgradeListener(listener);
        }
        return SQLiteDao.getInstance(mGlobalConfig);
    }

    public static void createTableIfNotExist(Class<?> tableCls){
        getDao().createTableIfNotExist(tableCls);
    }
	
	public static boolean isTableExist(String tableName){
		return isTableExist(null, tableName);
	}
	
	public static boolean isTableExist(String dbName, String tableName){
        SQLiteDao dao = getDao(dbName);
        String sql = "SELECT NAME FROM SQLITE_MASTER WHERE TYPE='table' AND NAME='"+ tableName +"'";
		JSONObject table = dao.getSingleValue(sql);
		return table != null;
	}
	
}
