/*
 * Decompiled with CFR 0.152.
 */
package com.bnystudio.library.jellydirectionbutton;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.util.AttributeSet;
import android.widget.FrameLayout;

public class JellyDirectionLayout
extends FrameLayout {
    public static final int NONE = 791;
    public static final int HORIENTAL = 271;
    public static final int VERTICAL = 694;
    protected Path path;
    protected Paint paint;
    protected float pullDistance;
    protected float defaultRadius;
    private float radius;
    private int mOrientation;

    public JellyDirectionLayout(Context context) {
        this(context, null, 0);
    }

    public JellyDirectionLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public JellyDirectionLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.setClickable(true);
        this.setWillNotDraw(false);
        if (this.isInEditMode()) {
            return;
        }
        this.mOrientation = 791;
        this.path = new Path();
        this.paint = new Paint();
        this.paint.setColor(this.getContext().getResources().getColor(17170459));
        this.paint.setAntiAlias(true);
    }

    public void setJellyColor(int jellyColor) {
        this.paint.setColor(jellyColor);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawJelly(canvas);
    }

    private void drawJelly(Canvas canvas) {
        float sRadius = this.radius == 0.0f ? this.defaultRadius : this.radius;
        float lRadius = this.radius == 0.0f ? this.defaultRadius : this.radius;
        PointF smallRoundCenter = this.getSmallRoundPoint(0.0f, 0.0f, this.mOrientation);
        PointF largeRoundCenter = this.getLargeRoundPoint(0.0f, 0.0f, this.mOrientation);
        canvas.drawCircle(smallRoundCenter.x, smallRoundCenter.y, sRadius, this.paint);
        if (this.mOrientation == 791) {
            return;
        }
        canvas.drawCircle(largeRoundCenter.x, largeRoundCenter.y, lRadius, this.paint);
        this.path.reset();
        if (this.mOrientation == 271) {
            this.path.moveTo(smallRoundCenter.x, smallRoundCenter.y - sRadius);
            this.path.quadTo((largeRoundCenter.x + smallRoundCenter.x) / 2.0f, smallRoundCenter.y - sRadius, largeRoundCenter.x, largeRoundCenter.y - lRadius);
            this.path.lineTo(largeRoundCenter.x, largeRoundCenter.y + lRadius);
            this.path.quadTo((largeRoundCenter.x + smallRoundCenter.x) / 2.0f, smallRoundCenter.y + sRadius, smallRoundCenter.x, largeRoundCenter.y + lRadius);
        } else {
            this.path.moveTo(smallRoundCenter.x - sRadius, smallRoundCenter.y);
            this.path.quadTo(smallRoundCenter.x - sRadius, (largeRoundCenter.y + smallRoundCenter.y) / 2.0f, largeRoundCenter.x - lRadius, largeRoundCenter.y);
            this.path.lineTo(largeRoundCenter.x + lRadius, largeRoundCenter.y);
            this.path.quadTo(smallRoundCenter.x + sRadius, (largeRoundCenter.y + smallRoundCenter.y) / 2.0f, smallRoundCenter.x + sRadius, smallRoundCenter.y);
        }
        canvas.drawPath(this.path, this.paint);
    }

    PointF getSmallRoundPoint(float x, float y, int orientation) {
        PointF ret = new PointF();
        float offsetX = (float)(this.getMeasuredWidth() / 2) + (orientation == 694 ? this.getTranslationX() : 0.0f);
        float offsetY = (float)(this.getMeasuredHeight() / 2) + (orientation == 271 ? this.getTranslationY() : 0.0f);
        ret.x = offsetX + x;
        ret.y = offsetY + y;
        return ret;
    }

    PointF getSmallRoundPoint(PointF pointF, int orientation) {
        PointF ret = new PointF();
        float offsetX = (float)(this.getMeasuredWidth() / 2) + (orientation == 694 ? this.getTranslationX() : 0.0f);
        float offsetY = (float)(this.getMeasuredHeight() / 2) + (orientation == 271 ? this.getTranslationY() : 0.0f);
        ret.x = offsetX + pointF.x;
        ret.y = offsetY + pointF.y;
        return ret;
    }

    PointF getLargeRoundPoint(float x, float y, int orientation) {
        PointF ret = new PointF();
        float offsetX = (float)(this.getMeasuredWidth() / 2) + (orientation == 694 ? this.getTranslationX() : this.pullDistance);
        float offsetY = (float)(this.getMeasuredHeight() / 2) + (orientation == 271 ? this.getTranslationY() : this.pullDistance);
        ret.x = offsetX + x;
        ret.y = offsetY + y;
        return ret;
    }

    PointF getLargeRoundPoint(PointF pointF, int orientation) {
        PointF ret = new PointF();
        float offsetX = (float)(this.getMeasuredWidth() / 2) + (orientation == 694 ? this.getTranslationX() : this.pullDistance);
        float offsetY = (float)(this.getMeasuredHeight() / 2) + (orientation == 271 ? this.getTranslationY() : this.pullDistance);
        ret.x = offsetX + pointF.x;
        ret.y = offsetY + pointF.y;
        return ret;
    }

    public void setDefaultRadius(float radius) {
        this.defaultRadius = radius;
    }

    public float getDefaultRadius() {
        return this.defaultRadius;
    }

    public void setPullDistance(float pullDistance) {
        this.pullDistance = pullDistance;
    }

    public float getPullDistance() {
        return this.pullDistance;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public float getRadius() {
        return this.radius != 0.0f ? this.radius : this.defaultRadius;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public void setmOrientation(int orientation) {
        this.mOrientation = orientation;
    }
}

