/*
 * Decompiled with CFR 0.152.
 */
package com.bnystudio.library.jellydirectionbutton;

import android.animation.Animator;
import android.animation.ArgbEvaluator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.OvershootInterpolator;
import android.widget.FrameLayout;
import com.bnystudio.library.jellydirectionbutton.JellyDirectionLayout;
import com.bnystudio.library.jellydirectionbutton.MathUtils;
import com.bnystudio.library.jellydirectionbutton.R;

public class JellyDirectionButtonLayout
extends FrameLayout {
    protected static final int MASK_DIRECTION = 65280;
    public static final int SWIPE_TO_NONE = 0;
    public static final int SWIPE_TO_DOWN = 256;
    public static final int SWIPE_TO_UP = 512;
    public static final int SWIPE_TO_RIGHT = 1024;
    public static final int SWIPE_TO_LEFT = 2048;
    protected static final int MASK_ORIENTATION = 255;
    protected static final int ORIENTATION_NONE = 0;
    protected static final int ORIENTATION_HORIZONTAL = 1;
    protected static final int ORIENTATION_VERTICAL = 2;
    protected static final float ACTIVE_Y = 30.0f;
    protected static final float ACTIVE_X = 30.0f;
    protected DecelerateInterpolator mDecelerateInterpolator;
    protected ArgbEvaluator mColorEvaluator;
    protected ValueAnimator mReturnAnimation;
    protected JellyDirectionLayout mJellyDirectionLayout;
    protected int mPermittedOrientation = 0;
    protected int mOrientation = 0;
    protected int mDirection = 0;
    protected int mPrevDirection = 0;
    protected boolean mIsLock;
    protected boolean mIsProcessing;
    protected boolean mIsActivate;
    protected boolean mPrevIsActivate;
    protected int mNormalColor;
    protected int mUpColor;
    protected int mDownColor;
    protected int mRightColor;
    protected int mLeftColor;
    protected float mTouchStartX;
    protected float mCurrentX;
    protected float mTouchStartY;
    protected float mCurrentY;
    protected OnJellyClickListener mJellyClickListener;
    protected View mChildView;

    public JellyDirectionButtonLayout(Context context) {
        super(context);
        this.init();
    }

    public JellyDirectionButtonLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setAttributes(attrs);
        this.init();
    }

    public JellyDirectionButtonLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setAttributes(attrs);
        this.init();
    }

    @TargetApi(value=21)
    public JellyDirectionButtonLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setAttributes(attrs);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAttributes(AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.JellyDirectionButtonLayout);
        try {
            Resources resources = this.getResources();
            this.mNormalColor = a.getColor(R.styleable.JellyDirectionButtonLayout_jellyNormalColor, resources.getColor(17170459));
            this.mDownColor = a.getColor(R.styleable.JellyDirectionButtonLayout_jellyDownColor, resources.getColor(17170459));
            this.mUpColor = a.getColor(R.styleable.JellyDirectionButtonLayout_jellyUpColor, resources.getColor(17170459));
            this.mRightColor = a.getColor(R.styleable.JellyDirectionButtonLayout_jellyRightColor, resources.getColor(17170459));
            this.mLeftColor = a.getColor(R.styleable.JellyDirectionButtonLayout_jellyLeftColor, resources.getColor(17170459));
            this.mPermittedOrientation = a.getInteger(R.styleable.JellyDirectionButtonLayout_jellyOrientation, 0);
        }
        finally {
            a.recycle();
        }
    }

    private void init() {
        if (this.isInEditMode()) {
            return;
        }
        if (this.getChildCount() > 1) {
            throw new RuntimeException("You can only attach one child");
        }
        this.mIsLock = false;
        this.mIsProcessing = false;
        this.mDecelerateInterpolator = new DecelerateInterpolator(10.0f);
        this.mColorEvaluator = new ArgbEvaluator();
        this.post(new Runnable(){

            @Override
            public void run() {
                int defaultRadius = (int)JellyDirectionButtonLayout.this.getDefaultRadius();
                JellyDirectionButtonLayout.this.mChildView = JellyDirectionButtonLayout.this.getChildAt(0);
                JellyDirectionButtonLayout.this.mJellyDirectionLayout = new JellyDirectionLayout(JellyDirectionButtonLayout.this.getContext());
                FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(defaultRadius * 2, defaultRadius * 2);
                params.gravity = 17;
                JellyDirectionButtonLayout.this.mJellyDirectionLayout.setLayoutParams((ViewGroup.LayoutParams)params);
                JellyDirectionButtonLayout.this.mJellyDirectionLayout.setDefaultRadius(JellyDirectionButtonLayout.this.getDefaultRadius());
                JellyDirectionButtonLayout.this.mJellyDirectionLayout.setJellyColor(JellyDirectionButtonLayout.this.mNormalColor);
                JellyDirectionButtonLayout.this.addView((View)JellyDirectionButtonLayout.this.mJellyDirectionLayout);
                JellyDirectionButtonLayout.this.setChildSize();
                if (JellyDirectionButtonLayout.this.mChildView != null) {
                    JellyDirectionButtonLayout.this.mChildView.bringToFront();
                }
            }
        });
    }

    private float getDefaultRadius() {
        float ret = 0.0f;
        float offsetX = Math.min(this.getMeasuredWidth() / 6, this.getMeasuredHeight() / 2);
        float offsetY = Math.min(this.getMeasuredWidth() / 2, this.getMeasuredHeight() / 6);
        if (this.mPermittedOrientation == 1) {
            ret = offsetX;
        } else if (this.mPermittedOrientation == 2) {
            ret = offsetY;
        } else if (this.mPermittedOrientation == 3) {
            ret = Math.min(offsetX, offsetY);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setChildSize() {
        if (this.mChildView == null) {
            return;
        }
        JellyDirectionButtonLayout jellyDirectionButtonLayout = this;
        synchronized (jellyDirectionButtonLayout) {
            FrameLayout.LayoutParams cParams = (FrameLayout.LayoutParams)this.mChildView.getLayoutParams();
            cParams.gravity = 17;
            cParams.width = (int)this.mJellyDirectionLayout.getRadius() * 2;
            cParams.height = (int)this.mJellyDirectionLayout.getRadius() * 2;
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent e) {
        if (this.mIsLock) {
            return false;
        }
        if (this.mIsProcessing) {
            return true;
        }
        switch (e.getAction()) {
            case 0: {
                this.mTouchStartX = e.getX();
                this.mTouchStartY = e.getY();
                this.mCurrentX = this.mTouchStartX;
                this.mCurrentY = this.mTouchStartY;
                if (this.mReturnAnimation != null) {
                    this.mReturnAnimation.cancel();
                }
                this.mPrevDirection = 0;
                this.mPrevIsActivate = false;
                break;
            }
            case 2: {
                float currentX = e.getX();
                float currentY = e.getY();
                float dx = currentX - this.mTouchStartX;
                float dy = currentY - this.mTouchStartY;
                if (Math.abs(dy) > 30.0f && (this.mPermittedOrientation & 2) == 2) {
                    this.mOrientation = 2;
                    this.mJellyDirectionLayout.setmOrientation(694);
                    return true;
                }
                if (!(Math.abs(dx) > 30.0f) || (this.mPermittedOrientation & 1) != 1) break;
                this.mOrientation = 1;
                this.mJellyDirectionLayout.setmOrientation(271);
                return true;
            }
        }
        return super.onInterceptTouchEvent(e);
    }

    public boolean onTouchEvent(@NonNull MotionEvent e) {
        if (this.mIsProcessing) {
            return super.onTouchEvent(e);
        }
        switch (e.getAction()) {
            case 2: {
                float diff = 0.0f;
                this.mCurrentX = e.getX();
                this.mCurrentY = e.getY();
                float maxValue = 0.0f;
                this.mPrevDirection = this.mDirection;
                this.mDirection = this.mOrientation == 1 ? ((diff = MathUtils.constrains(this.mCurrentX - this.mTouchStartX, maxValue = (float)(this.getMeasuredWidth() / 3))) > 0.0f ? 1024 : 2048) : ((diff = MathUtils.constrains(this.mCurrentY - this.mTouchStartY, maxValue = (float)(this.getMeasuredHeight() / 3))) > 0.0f ? 256 : 512);
                float offset = this.mDecelerateInterpolator.getInterpolation(Math.abs(diff) / maxValue) * diff;
                float fraction = offset / maxValue;
                this.updateButtonColor(fraction, this.mDirection);
                if (this.mJellyDirectionLayout != null) {
                    this.updateJellyDirectionLayout(offset, false);
                }
                this.mPrevIsActivate = this.mIsActivate;
                boolean bl = this.mIsActivate = Math.abs(offset) > maxValue / 2.0f;
                if (this.mJellyClickListener != null && (this.mPrevIsActivate != this.mIsActivate || this.mPrevDirection != this.mDirection)) {
                    this.mJellyClickListener.onReadyClick(this, this.mDirection, this.mIsActivate, fraction);
                }
                return true;
            }
            case 1: 
            case 3: {
                this.onTouchFinish(this.mDirection);
                this.returnStartPosition();
                return true;
            }
        }
        return super.onTouchEvent(e);
    }

    protected float getButtonRadius(float offset) {
        return this.mJellyDirectionLayout.getDefaultRadius() - Math.abs((float)((double)offset * 0.1));
    }

    private void updateButtonColor(float fraction, int direction) {
        int targetColor = this.mNormalColor;
        if (direction == 256) {
            targetColor = this.mDownColor;
        } else if (direction == 512) {
            targetColor = this.mUpColor;
        }
        int color2 = (Integer)this.mColorEvaluator.evaluate(MathUtils.constrains(0.0f, 1.0f, Math.abs(fraction)), (Object)this.mNormalColor, (Object)targetColor);
        this.mJellyDirectionLayout.setJellyColor(color2);
    }

    private void onTouchFinish(int direction) {
        this.mIsProcessing = true;
        if (this.mJellyClickListener != null && this.mIsActivate) {
            this.mJellyClickListener.onClick(this, direction);
        } else {
            this.setClickFinish();
        }
    }

    private void returnStartPosition() {
        this.mReturnAnimation = ValueAnimator.ofFloat((float[])new float[]{this.mJellyDirectionLayout.getPullDistance(), 0.0f});
        this.mReturnAnimation.setDuration(100L);
        this.mReturnAnimation.setInterpolator((TimeInterpolator)new OvershootInterpolator(2.0f));
        this.mReturnAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float value = ((Float)animation.getAnimatedValue()).floatValue();
                JellyDirectionButtonLayout.this.updateButtonColor(value / JellyDirectionButtonLayout.this.mJellyDirectionLayout.getDefaultRadius(), JellyDirectionButtonLayout.this.mDirection);
                JellyDirectionButtonLayout.this.updateJellyDirectionLayout(value, false);
            }
        });
        this.mReturnAnimation.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                JellyDirectionButtonLayout.this.updateJellyDirectionLayout(0.0f, true);
            }

            public void onAnimationCancel(Animator animation) {
                JellyDirectionButtonLayout.this.updateJellyDirectionLayout(0.0f, true);
            }
        });
        this.mReturnAnimation.start();
    }

    public void updateJellyDirectionLayout(float offset, boolean isIdle) {
        float radius = this.getButtonRadius(offset);
        this.mJellyDirectionLayout.setRadius(radius);
        this.mJellyDirectionLayout.setPullDistance(offset);
        this.setChildSize();
        if (this.mChildView == null) {
            this.mJellyDirectionLayout.postInvalidate();
        } else {
            this.mJellyDirectionLayout.requestLayout();
        }
        this.setJellyDirectionLayoutSize(isIdle);
    }

    public void setJellyDirectionLayoutSize(boolean isIdle) {
        float width = this.getMeasuredWidth();
        float height = this.getMeasuredHeight();
        if (isIdle) {
            width = this.getDefaultRadius() * 2.0f;
            height = this.getDefaultRadius() * 2.0f;
        }
        this.mJellyDirectionLayout.getLayoutParams().width = (int)width;
        this.mJellyDirectionLayout.getLayoutParams().height = (int)height;
        this.mJellyDirectionLayout.requestLayout();
    }

    public int getDirection() {
        return this.mDirection;
    }

    public void setNormalColor(int normalColor) {
        this.mNormalColor = normalColor;
    }

    public void setUpColor(int upColor) {
        this.mUpColor = upColor;
    }

    public void setDownColor(int downColor) {
        this.mDownColor = downColor;
    }

    public void setRightColor(int rightColor) {
        this.mRightColor = rightColor;
    }

    public void setLeftColor(int leftColor) {
        this.mLeftColor = leftColor;
    }

    public void lock() {
        this.mIsLock = true;
    }

    public void unLock() {
        this.mIsLock = false;
    }

    public void setOnJellyClickListener(OnJellyClickListener listener) {
        this.mJellyClickListener = listener;
    }

    public void setClickFinish() {
        this.mIsProcessing = false;
        this.mIsActivate = false;
    }

    public static interface OnJellyClickListener {
        public void onReadyClick(JellyDirectionButtonLayout var1, int var2, boolean var3, float var4);

        public void onClick(JellyDirectionButtonLayout var1, int var2);
    }
}

