/*
 * Decompiled with CFR 0.152.
 */
package com.bnystudio.library.jellydirectionbutton;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.util.AttributeSet;
import android.widget.FrameLayout;

public class JellyDirectionLayout
extends FrameLayout {
    protected Path path;
    protected Paint paint;
    protected float pullHeight;
    protected float defaultRadius;
    private boolean isMouseDown;
    private float radius;

    public JellyDirectionLayout(Context context) {
        this(context, null, 0);
    }

    public JellyDirectionLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public JellyDirectionLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.setClickable(true);
        this.setWillNotDraw(false);
        if (this.isInEditMode()) {
            return;
        }
        this.path = new Path();
        this.paint = new Paint();
        this.paint.setColor(this.getContext().getResources().getColor(17170459));
        this.paint.setAntiAlias(true);
    }

    public void setJellyColor(int jellyColor) {
        this.paint.setColor(jellyColor);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawJelly(canvas);
    }

    private void drawJelly(Canvas canvas) {
        float sRadius = this.radius == 0.0f ? this.defaultRadius : this.radius;
        float lRadius = Math.max(Math.abs((float)((double)this.pullHeight * 0.4)), this.radius);
        PointF smallRoundCenter = this.getSmallRoundPoint(0.0f, 0.0f);
        PointF largeRoundCenter = this.getLargeRoundPoint(0.0f, 0.0f);
        canvas.drawCircle(smallRoundCenter.x, smallRoundCenter.y, sRadius, this.paint);
        canvas.drawCircle(largeRoundCenter.x, largeRoundCenter.y, lRadius, this.paint);
        this.path.reset();
        this.path.moveTo(smallRoundCenter.x - sRadius, smallRoundCenter.y);
        this.path.quadTo(smallRoundCenter.x - sRadius, (largeRoundCenter.y + smallRoundCenter.y) / 2.0f, largeRoundCenter.x - lRadius, largeRoundCenter.y);
        this.path.lineTo(largeRoundCenter.x + lRadius, largeRoundCenter.y);
        this.path.quadTo(smallRoundCenter.x + sRadius, (largeRoundCenter.y + smallRoundCenter.y) / 2.0f, smallRoundCenter.x + sRadius, smallRoundCenter.y);
        canvas.drawPath(this.path, this.paint);
    }

    PointF getSmallRoundPoint(float x, float y) {
        PointF ret = new PointF();
        float offsetX = (float)(this.getMeasuredWidth() / 2) + this.getTranslationX();
        float offsetY = this.getMeasuredHeight() / 2;
        ret.x = offsetX + x;
        ret.y = offsetY + y;
        return ret;
    }

    PointF getSmallRoundPoint(PointF pointF) {
        PointF ret = new PointF();
        float offsetX = (float)(this.getMeasuredWidth() / 2) + this.getTranslationX();
        float offsetY = this.getMeasuredHeight() / 2;
        ret.x = offsetX + pointF.x;
        ret.y = offsetY + pointF.y;
        return ret;
    }

    PointF getLargeRoundPoint(float x, float y) {
        PointF ret = new PointF();
        float offsetX = (float)(this.getMeasuredWidth() / 2) + this.getTranslationX();
        float offsetY = (float)(this.getMeasuredHeight() / 2) + this.pullHeight;
        ret.x = offsetX + x;
        ret.y = offsetY + y;
        return ret;
    }

    PointF getLargeRoundPoint(PointF pointF) {
        PointF ret = new PointF();
        float offsetX = (float)(this.getMeasuredWidth() / 2) + this.getTranslationX();
        float offsetY = this.getMeasuredHeight() / 2;
        ret.x = offsetX + pointF.x;
        ret.y = offsetY + pointF.y;
        return ret;
    }

    public void setDefaultRadius(float radius) {
        this.defaultRadius = radius;
    }

    public float getDefaultRadius() {
        return this.defaultRadius;
    }

    public void setPullHeight(float pullHeight) {
        this.pullHeight = pullHeight;
    }

    public float getPullHeight() {
        return this.pullHeight;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public float getRadius() {
        return this.radius != 0.0f ? this.radius : this.defaultRadius;
    }
}

