/*
 * Decompiled with CFR 0.152.
 */
package com.bnystudio.library.jellydirectionbutton;

import android.animation.Animator;
import android.animation.ArgbEvaluator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.OvershootInterpolator;
import android.widget.FrameLayout;
import com.bnystudio.library.jellydirectionbutton.JellyDirectionLayout;
import com.bnystudio.library.jellydirectionbutton.MathUtils;
import com.bnystudio.library.jellydirectionbutton.R;

public class JellyDirectionButtonLayout
extends FrameLayout {
    public static final int SWIPE_TO_NONE = 0;
    public static final int SWIPE_TO_DOWN = -1;
    public static final int SWIPE_TO_UP = 1;
    protected static final int ANIMATION_DURATION = 200;
    protected static final float ACTIVE_Y = 10.0f;
    protected DecelerateInterpolator mDecelerateInterpolator;
    protected ArgbEvaluator mColorEvaluator;
    protected ValueAnimator mReturnAnimation;
    protected JellyDirectionLayout mJellyDirectionLayout;
    protected int mDirection = 0;
    protected int mPrevDirection = 0;
    protected boolean mIsLock;
    protected boolean mIsProcessing;
    protected boolean mIsActivate;
    protected boolean mPrevIsActivate;
    protected int mNormalColor;
    protected int mUpColor;
    protected int mDownColor;
    protected float mTouchStartY;
    protected float mCurrentY;
    protected OnJellyClickListener mJellyClickListener;
    protected View mChildView;

    public JellyDirectionButtonLayout(Context context) {
        super(context);
        this.init();
    }

    public JellyDirectionButtonLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setAttributes(attrs);
        this.init();
    }

    public JellyDirectionButtonLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setAttributes(attrs);
        this.init();
    }

    @TargetApi(value=21)
    public JellyDirectionButtonLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setAttributes(attrs);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAttributes(AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.JellyDirectionButtonLayout);
        try {
            Resources resources = this.getResources();
            this.mNormalColor = a.getColor(R.styleable.JellyDirectionButtonLayout_jellyNormalColor, resources.getColor(17170459));
            this.mDownColor = a.getColor(R.styleable.JellyDirectionButtonLayout_jellyDownColor, resources.getColor(17170459));
            this.mUpColor = a.getColor(R.styleable.JellyDirectionButtonLayout_jellyUpColor, resources.getColor(17170459));
        }
        finally {
            a.recycle();
        }
    }

    private void init() {
        if (this.isInEditMode()) {
            return;
        }
        if (this.getChildCount() > 1) {
            throw new RuntimeException("You can only attach one child");
        }
        this.mIsLock = false;
        this.mIsProcessing = false;
        this.mDecelerateInterpolator = new DecelerateInterpolator(10.0f);
        this.mColorEvaluator = new ArgbEvaluator();
        this.post(new Runnable(){

            @Override
            public void run() {
                JellyDirectionButtonLayout.this.mChildView = JellyDirectionButtonLayout.this.getChildAt(0);
                JellyDirectionButtonLayout.this.mJellyDirectionLayout = new JellyDirectionLayout(JellyDirectionButtonLayout.this.getContext());
                FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(JellyDirectionButtonLayout.this.getMeasuredWidth(), JellyDirectionButtonLayout.this.getMeasuredHeight() / 3);
                params.gravity = 17;
                JellyDirectionButtonLayout.this.mJellyDirectionLayout.setLayoutParams((ViewGroup.LayoutParams)params);
                JellyDirectionButtonLayout.this.mJellyDirectionLayout.setDefaultRadius(JellyDirectionButtonLayout.this.getMeasuredHeight() / 6);
                JellyDirectionButtonLayout.this.mJellyDirectionLayout.setJellyColor(JellyDirectionButtonLayout.this.mNormalColor);
                JellyDirectionButtonLayout.this.addView((View)JellyDirectionButtonLayout.this.mJellyDirectionLayout);
                JellyDirectionButtonLayout.this.setChildSize();
                if (JellyDirectionButtonLayout.this.mChildView != null) {
                    JellyDirectionButtonLayout.this.mChildView.bringToFront();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setChildSize() {
        if (this.mChildView == null) {
            return;
        }
        JellyDirectionButtonLayout jellyDirectionButtonLayout = this;
        synchronized (jellyDirectionButtonLayout) {
            FrameLayout.LayoutParams cParams = (FrameLayout.LayoutParams)this.mChildView.getLayoutParams();
            cParams.gravity = 17;
            cParams.width = (int)this.mJellyDirectionLayout.getRadius() * 2;
            cParams.height = (int)this.mJellyDirectionLayout.getRadius() * 2;
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent e) {
        if (this.mIsLock) {
            return false;
        }
        if (this.mIsProcessing) {
            return true;
        }
        switch (e.getAction()) {
            case 0: {
                this.mCurrentY = this.mTouchStartY = e.getY();
                if (this.mReturnAnimation != null) {
                    this.mReturnAnimation.cancel();
                }
                this.mPrevDirection = 0;
                this.mPrevIsActivate = false;
                break;
            }
            case 2: {
                float currentY = e.getY();
                float dy = currentY - this.mTouchStartY;
                if (!(Math.abs(dy) > 10.0f)) break;
                return true;
            }
        }
        return super.onInterceptTouchEvent(e);
    }

    public boolean onTouchEvent(@NonNull MotionEvent e) {
        if (this.mIsProcessing) {
            return super.onTouchEvent(e);
        }
        switch (e.getAction()) {
            case 2: {
                this.mCurrentY = e.getY();
                float maxValue = this.getMeasuredHeight() / 3;
                float dy = MathUtils.constrains(this.mCurrentY - this.mTouchStartY, maxValue);
                this.mPrevDirection = this.mDirection;
                this.mDirection = dy > 0.0f ? -1 : 1;
                float offsetY = this.mDecelerateInterpolator.getInterpolation(Math.abs(dy) / (float)(this.getMeasuredHeight() / 3)) * dy;
                float fraction = offsetY / maxValue;
                this.updateButtonColor(fraction, this.mDirection);
                if (this.mJellyDirectionLayout != null) {
                    this.updateJellyDirectionLayout(offsetY, false);
                }
                this.mPrevIsActivate = this.mIsActivate;
                boolean bl = this.mIsActivate = Math.abs(offsetY) > maxValue / 2.0f;
                if (this.mJellyClickListener != null && (this.mPrevIsActivate != this.mIsActivate || this.mPrevDirection != this.mDirection)) {
                    this.mJellyClickListener.onReadyClick(this, this.mDirection, this.mIsActivate, fraction);
                }
                return true;
            }
            case 1: 
            case 3: {
                this.onTouchFinish(this.mDirection);
                this.returnStartPosition();
                return true;
            }
        }
        return super.onTouchEvent(e);
    }

    protected float getButtonRadius(float offsetY) {
        return this.mJellyDirectionLayout.getDefaultRadius() - Math.abs((float)((double)offsetY * 0.1));
    }

    private void updateButtonColor(float fraction, int direction) {
        int targetColor = this.mNormalColor;
        if (direction == -1) {
            targetColor = this.mDownColor;
        } else if (direction == 1) {
            targetColor = this.mUpColor;
        }
        int color = (Integer)this.mColorEvaluator.evaluate(MathUtils.constrains(0.0f, 1.0f, Math.abs(fraction)), (Object)this.mNormalColor, (Object)targetColor);
        this.mJellyDirectionLayout.setJellyColor(color);
    }

    private void onTouchFinish(int direction) {
        this.mIsProcessing = true;
        if (this.mJellyClickListener != null && this.mIsActivate) {
            this.mJellyClickListener.onClick(this, direction);
        } else {
            this.setClickFinish();
        }
    }

    private void returnStartPosition() {
        this.mReturnAnimation = ValueAnimator.ofFloat((float[])new float[]{this.mJellyDirectionLayout.getPullHeight(), 0.0f});
        this.mReturnAnimation.setDuration(100L);
        this.mReturnAnimation.setInterpolator((TimeInterpolator)new OvershootInterpolator(2.0f));
        this.mReturnAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float value = ((Float)animation.getAnimatedValue()).floatValue();
                JellyDirectionButtonLayout.this.updateButtonColor(value / (float)(JellyDirectionButtonLayout.this.getMeasuredHeight() / 4), JellyDirectionButtonLayout.this.mDirection);
                JellyDirectionButtonLayout.this.updateJellyDirectionLayout(value, false);
            }
        });
        this.mReturnAnimation.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                JellyDirectionButtonLayout.this.updateJellyDirectionLayout(0.0f, true);
            }

            public void onAnimationCancel(Animator animation) {
                JellyDirectionButtonLayout.this.updateJellyDirectionLayout(0.0f, true);
            }
        });
        this.mReturnAnimation.start();
    }

    public void updateJellyDirectionLayout(float offsetY, boolean isIdle) {
        float radius = this.getButtonRadius(offsetY);
        this.mJellyDirectionLayout.setRadius(radius);
        this.mJellyDirectionLayout.setPullHeight(offsetY);
        this.setChildSize();
        if (this.mChildView == null) {
            this.mJellyDirectionLayout.postInvalidate();
        } else {
            this.mJellyDirectionLayout.requestLayout();
        }
        this.setJellyDirectionLayoutSize(isIdle);
    }

    public void setJellyDirectionLayoutSize(boolean isIdle) {
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        if (isIdle) {
            height /= 3;
        }
        this.mJellyDirectionLayout.getLayoutParams().width = width;
        this.mJellyDirectionLayout.getLayoutParams().height = height;
        this.mJellyDirectionLayout.requestLayout();
    }

    public int getDirection() {
        return this.mDirection;
    }

    public void setNormalColor(int normalColor) {
        this.mNormalColor = normalColor;
    }

    public void setUpColor(int upColor) {
        this.mUpColor = upColor;
    }

    public void setDownColor(int downColor) {
        this.mDownColor = downColor;
    }

    public void lock() {
        this.mIsLock = true;
    }

    public void unLock() {
        this.mIsLock = false;
    }

    public void setOnJellyClickListener(OnJellyClickListener listener) {
        this.mJellyClickListener = listener;
    }

    public void setClickFinish() {
        this.mIsProcessing = false;
        this.mIsActivate = false;
    }

    public static interface OnJellyClickListener {
        public void onReadyClick(JellyDirectionButtonLayout var1, int var2, boolean var3, float var4);

        public void onClick(JellyDirectionButtonLayout var1, int var2);
    }
}

