/*
 * Decompiled with CFR 0.152.
 */
package com.dementh.lib.battlenet_oauth2.connections;

import android.content.SharedPreferences;
import android.util.Log;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.CredentialStore;
import java.io.IOException;

public class BnSharedPreferencesCredentialStore
implements CredentialStore {
    private static final String ACCESS_TOKEN = "_access_token";
    private static final String EXPIRES_IN = "_expires_in";
    private static final String REFRESH_TOKEN = "_refresh_token";
    private static final String SCOPE = "_scope";
    private SharedPreferences prefs;

    public BnSharedPreferencesCredentialStore(SharedPreferences prefs) {
        this.prefs = prefs;
    }

    public boolean load(String userId, Credential credential) throws IOException {
        Log.i((String)"Battlenet-OAuth2", (String)"Loading credential for userId ".concat(userId));
        Log.i((String)"Battlenet-OAuth2", (String)"Loaded access token = ".concat(this.prefs.getString(userId + ACCESS_TOKEN, "")));
        credential.setAccessToken(this.prefs.getString(userId + ACCESS_TOKEN, null));
        if (this.prefs.contains(userId + EXPIRES_IN)) {
            credential.setExpirationTimeMilliseconds(Long.valueOf(this.prefs.getLong(userId + EXPIRES_IN, 0L)));
        }
        credential.setRefreshToken(this.prefs.getString(userId + REFRESH_TOKEN, null));
        return true;
    }

    public void store(String userId, Credential credential) throws IOException {
        Log.i((String)"Battlenet-OAuth2", (String)"Storing credential for userId ".concat(userId));
        Log.i((String)"Battlenet-OAuth2", (String)"Access Token = ".concat(credential.getAccessToken()));
        SharedPreferences.Editor editor = this.prefs.edit();
        editor.putString(userId + ACCESS_TOKEN, credential.getAccessToken());
        if (credential.getExpirationTimeMilliseconds() != null) {
            editor.putLong(userId + EXPIRES_IN, credential.getExpirationTimeMilliseconds().longValue());
        }
        if (credential.getRefreshToken() != null) {
            editor.putString(userId + REFRESH_TOKEN, credential.getRefreshToken());
        }
        editor.commit();
    }

    public void delete(String userId, Credential credential) throws IOException {
        Log.i((String)"Battlenet-OAuth2", (String)"Deleting credential for userId ".concat(userId));
        SharedPreferences.Editor editor = this.prefs.edit();
        editor.remove(userId + ACCESS_TOKEN);
        editor.remove(userId + EXPIRES_IN);
        editor.remove(userId + REFRESH_TOKEN);
        editor.remove(userId + SCOPE);
        editor.commit();
    }
}

