/*
 * Decompiled with CFR 0.152.
 */
package com.dementh.lib.battlenet_oauth2.connections;

import android.os.Parcel;
import android.os.Parcelable;
import com.dementh.lib.battlenet_oauth2.connections.BnQueryParamsAccessMethod;
import com.google.api.client.auth.oauth2.Credential;

public class BnOAuth2Params
implements Parcelable {
    private static final String ZONE_DEFAULT = "zone";
    private String clientId;
    private String clientSecret;
    private String scope;
    private String rederictUri;
    private String userId;
    private String zone;
    private String tokenServerUrl = "https://zone.battle.net/oauth/token";
    private String authorizationServerEncodedUrl = "https://zone.battle.net/oauth/authorize";
    public static final Parcelable.Creator<BnOAuth2Params> CREATOR = new Parcelable.Creator<BnOAuth2Params>(){

        public BnOAuth2Params createFromParcel(Parcel source) {
            return new BnOAuth2Params(source);
        }

        public BnOAuth2Params[] newArray(int size) {
            return new BnOAuth2Params[size];
        }
    };

    public BnOAuth2Params(String clientId, String clientSecret, String zone, String rederictUri, String userId, String ... scopes) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.zone = zone;
        this.tokenServerUrl = this.tokenServerUrl.replace(ZONE_DEFAULT, zone);
        this.authorizationServerEncodedUrl = this.authorizationServerEncodedUrl.replace(ZONE_DEFAULT, zone);
        this.rederictUri = rederictUri;
        this.userId = userId;
        StringBuilder sb = new StringBuilder();
        if (null != scopes && 0 < scopes.length) {
            for (String scope : scopes) {
                sb.append(scope).append("+");
            }
        } else {
            sb.append("wow.profile").append("+");
            sb.append("sc2.profile").append("+");
        }
        this.scope = sb.toString().substring(0, sb.toString().length() - 1);
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getRederictUri() {
        return this.rederictUri;
    }

    public void setRederictUri(String rederictUri) {
        this.rederictUri = rederictUri;
    }

    public String getTokenServerUrl() {
        return this.tokenServerUrl;
    }

    public void setTokenServerUrl(String tokenServerUrl) {
        this.tokenServerUrl = tokenServerUrl;
    }

    public String getAuthorizationServerEncodedUrl() {
        return this.authorizationServerEncodedUrl;
    }

    public void setAuthorizationServerEncodedUrl(String authorizationServerEncodedUrl) {
        this.authorizationServerEncodedUrl = authorizationServerEncodedUrl;
    }

    public String getZone() {
        return this.zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public Credential.AccessMethod getAccessMethod() {
        return BnQueryParamsAccessMethod.getInstance();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.clientId);
        dest.writeString(this.clientSecret);
        dest.writeString(this.scope);
        dest.writeString(this.rederictUri);
        dest.writeString(this.userId);
        dest.writeString(this.zone);
        dest.writeString(this.tokenServerUrl);
        dest.writeString(this.authorizationServerEncodedUrl);
    }

    protected BnOAuth2Params(Parcel in) {
        this.clientId = in.readString();
        this.clientSecret = in.readString();
        this.scope = in.readString();
        this.rederictUri = in.readString();
        this.userId = in.readString();
        this.zone = in.readString();
        this.tokenServerUrl = in.readString();
        this.authorizationServerEncodedUrl = in.readString();
    }
}

