/*
 * Decompiled with CFR 0.152.
 */
package com.dementh.lib.battlenet_oauth2.connections;

import android.content.SharedPreferences;
import android.util.Log;
import com.dementh.lib.battlenet_oauth2.connections.BnOAuth2Params;
import com.dementh.lib.battlenet_oauth2.connections.BnSharedPreferencesCredentialStore;
import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.CredentialStore;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class BnOAuth2Helper {
    private static final HttpTransport HTTP_TRANSPORT = new NetHttpTransport();
    private static final JsonFactory JSON_FACTORY = new JacksonFactory();
    private final CredentialStore credentialStore;
    private AuthorizationCodeFlow flow;
    private BnOAuth2Params oauth2Params;

    public BnOAuth2Helper(SharedPreferences sharedPreferences, BnOAuth2Params oauth2Params) {
        this.credentialStore = new BnSharedPreferencesCredentialStore(sharedPreferences);
        this.oauth2Params = oauth2Params;
        this.flow = new AuthorizationCodeFlow.Builder(oauth2Params.getAccessMethod(), HTTP_TRANSPORT, JSON_FACTORY, new GenericUrl(oauth2Params.getTokenServerUrl()), (HttpExecuteInterceptor)new ClientParametersAuthentication(oauth2Params.getClientId(), oauth2Params.getClientSecret()), oauth2Params.getClientId(), oauth2Params.getAuthorizationServerEncodedUrl()).setCredentialStore(this.credentialStore).build();
    }

    public String getAuthorizationUrl() {
        String authorizationUrl = this.flow.newAuthorizationUrl().setRedirectUri(this.oauth2Params.getRederictUri()).setScopes(this.convertScopesToString(this.oauth2Params.getScope())).build();
        return authorizationUrl;
    }

    public void retrieveAndStoreAccessToken(String authorizationCode) throws IOException {
        Log.i((String)"Battlenet-OAuth2", (String)"retrieveAndStoreAccessToken for code ".concat(authorizationCode));
        TokenResponse tokenResponse = this.flow.newTokenRequest(authorizationCode).setScopes(this.convertScopesToString(this.oauth2Params.getScope())).setRedirectUri(this.oauth2Params.getRederictUri()).execute();
        Log.i((String)"Battlenet-OAuth2", (String)"Found tokenResponse");
        if (null != tokenResponse.getAccessToken()) {
            Log.i((String)"Battlenet-OAuth2", (String)"Access Token : ".concat(tokenResponse.getAccessToken()));
        }
        if (null != tokenResponse.getRefreshToken()) {
            Log.i((String)"Battlenet-OAuth2", (String)"Refresh Token : ".concat(tokenResponse.getRefreshToken()));
        }
        this.flow.createAndStoreCredential(tokenResponse, this.oauth2Params.getUserId());
    }

    public String getAccessToken() throws IOException {
        return this.flow.loadCredential(this.oauth2Params.getUserId()).getAccessToken();
    }

    public Credential loadCredential() throws IOException {
        return this.flow.loadCredential(this.oauth2Params.getUserId());
    }

    public void clearCredentials() throws IOException {
        this.flow.getCredentialStore().delete(this.oauth2Params.getUserId(), null);
    }

    private Collection<String> convertScopesToString(String scopesConcat) {
        String[] scopes = scopesConcat.split(",");
        ArrayList<String> collection = new ArrayList<String>();
        Collections.addAll(collection, scopes);
        return collection;
    }
}

