/*
 * Decompiled with CFR 0.152.
 */
package com.dementh.lib.battlenet_oauth2.activities;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Parcelable;
import android.preference.PreferenceManager;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.View;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.dementh.lib.battlenet_oauth2.connections.BnOAuth2Helper;
import com.dementh.lib.battlenet_oauth2.connections.BnOAuth2Params;
import java.net.URLDecoder;

public class BnOAuthAccessTokenActivity
extends AppCompatActivity {
    private SharedPreferences prefs;
    private BnOAuth2Helper oAuth2Helper;
    private WebView webview;
    boolean handled = false;
    private boolean hasLoggedIn;
    private BnOAuth2Params bnOAuth2Params;
    private Class redirectActivity;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Log.i((String)"Battlenet-OAuth2", (String)"Starting task to retrieve request token");
        this.prefs = PreferenceManager.getDefaultSharedPreferences((Context)this);
        Bundle bundle = this.getIntent().getExtras();
        this.redirectActivity = (Class)bundle.get("BUNDLE_REDIRECT_ACTIVITY");
        this.bnOAuth2Params = (BnOAuth2Params)bundle.getParcelable("BUNDLE_BNPARAMS");
        this.oAuth2Helper = new BnOAuth2Helper(this.prefs, this.bnOAuth2Params);
        this.webview = new WebView((Context)this);
        this.webview.getSettings().setJavaScriptEnabled(true);
        this.webview.setVisibility(0);
        this.setContentView((View)this.webview);
        String authorizationUrl = this.oAuth2Helper.getAuthorizationUrl();
        Log.i((String)"Battlenet-OAuth2", (String)("Using authorizationUrl = " + authorizationUrl));
        this.handled = false;
        this.webview.setWebViewClient(new WebViewClient(){

            public void onPageStarted(WebView view, String url, Bitmap bitmap) {
                Log.d((String)"Battlenet-OAuth2", (String)("onPageStarted : " + url + " handled = " + BnOAuthAccessTokenActivity.this.handled));
            }

            public void onPageFinished(WebView view, String url) {
                Log.d((String)"Battlenet-OAuth2", (String)("onPageFinished : " + url + " handled = " + BnOAuthAccessTokenActivity.this.handled));
                if (url.startsWith(BnOAuthAccessTokenActivity.this.bnOAuth2Params.getRederictUri())) {
                    BnOAuthAccessTokenActivity.this.webview.setVisibility(4);
                    if (!BnOAuthAccessTokenActivity.this.handled) {
                        new ProcessToken(url).execute(new Uri[0]);
                    }
                } else {
                    BnOAuthAccessTokenActivity.this.webview.setVisibility(0);
                }
            }
        });
        this.webview.loadUrl(authorizationUrl);
    }

    protected void onResume() {
        super.onResume();
        Log.i((String)"Battlenet-OAuth2", (String)("onResume called with " + this.hasLoggedIn));
        if (this.hasLoggedIn) {
            this.finish();
        }
    }

    private class ProcessToken
    extends AsyncTask<Uri, Void, Void> {
        String url;
        boolean startActivity = false;

        public ProcessToken(String url) {
            this.url = url;
        }

        protected Void doInBackground(Uri ... params) {
            if (this.url.startsWith(BnOAuthAccessTokenActivity.this.bnOAuth2Params.getRederictUri())) {
                Log.i((String)"Battlenet-OAuth2", (String)"Redirect URL found: ".concat(this.url));
                BnOAuthAccessTokenActivity.this.handled = true;
                try {
                    if (this.url.indexOf("code=") != -1) {
                        String authorizationCode = this.extractCodeFromUrl(this.url);
                        Log.i((String)"Battlenet-OAuth2", (String)"Found code = ".concat(authorizationCode));
                        BnOAuthAccessTokenActivity.this.oAuth2Helper.retrieveAndStoreAccessToken(authorizationCode);
                        this.startActivity = true;
                        BnOAuthAccessTokenActivity.this.hasLoggedIn = true;
                    } else if (this.url.indexOf("error=") != -1) {
                        this.startActivity = true;
                    }
                }
                catch (Exception e) {
                    Log.e((String)"Battlenet-OAuth2", (String)"Error processing token", (Throwable)e);
                }
            } else {
                Log.i((String)"Battlenet-OAuth2", (String)"Not doing anything for url ".concat(this.url));
            }
            return null;
        }

        private String extractCodeFromUrl(String url) throws Exception {
            String encodedCode = url.substring(BnOAuthAccessTokenActivity.this.bnOAuth2Params.getRederictUri().length() + 7, url.length());
            return URLDecoder.decode(encodedCode, "UTF-8");
        }

        protected void onPreExecute() {
        }

        protected void onPostExecute(Void result) {
            if (this.startActivity) {
                Log.i((String)"Battlenet-OAuth2", (String)" Redirect to the activity you want: ".concat(BnOAuthAccessTokenActivity.this.redirectActivity.getName()));
                Intent intent = new Intent((Context)BnOAuthAccessTokenActivity.this, BnOAuthAccessTokenActivity.this.redirectActivity);
                intent.putExtra("BUNDLE_BNPARAMS", (Parcelable)BnOAuthAccessTokenActivity.this.bnOAuth2Params);
                BnOAuthAccessTokenActivity.this.startActivity(intent);
                BnOAuthAccessTokenActivity.this.finish();
            }
        }
    }
}

