/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.internal;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class CopyUtils {
    private CopyUtils() {
    }

    public static void copySingleFile(Path hostDestination, Path tempDestination) throws IOException {
        List files;
        if (Files.exists(hostDestination, new LinkOption[0]) && !Files.isDirectory(hostDestination, new LinkOption[0])) {
            Files.delete(hostDestination);
        }
        if (!Files.exists(hostDestination, new LinkOption[0]) && !Files.exists(hostDestination.getParent(), new LinkOption[0])) {
            Files.createDirectories(hostDestination.getParent(), new FileAttribute[0]);
        }
        Path parentDirectory = Files.isDirectory(hostDestination, new LinkOption[0]) ? hostDestination : hostDestination.getParent();
        try (Stream<Path> stream = Files.list(tempDestination);){
            files = stream.collect(Collectors.toList());
        }
        Path fileName = Files.isDirectory(hostDestination, new LinkOption[0]) ? ((Path)files.get(0)).getFileName() : hostDestination.getFileName();
        Path destination = parentDirectory.resolve(fileName);
        Files.move((Path)files.get(0), destination, new CopyOption[0]);
    }

    public static void copyMultipleFiles(Path hostDestination, Path tempDestination) throws IOException {
        List files;
        try (Stream<Path> stream = Files.list(tempDestination);){
            files = stream.collect(Collectors.toList());
        }
        if (files.size() == 1) {
            List filesToMove;
            Path dirToFlatten = (Path)files.get(0);
            Path dirToFlattenParent = dirToFlatten.getParent();
            Path flatDir = dirToFlattenParent.resolve(UUID.randomUUID().toString());
            Files.move(dirToFlatten, flatDir, new CopyOption[0]);
            try (Stream<Path> stream = Files.list(flatDir);){
                filesToMove = stream.collect(Collectors.toList());
            }
            for (Path it : filesToMove) {
                Path movedFile = dirToFlattenParent.resolve(it.getFileName());
                Files.move(it, movedFile, new CopyOption[0]);
            }
            try (Stream<Path> walk = Files.walk(flatDir, new FileVisitOption[0]);){
                walk.sorted(Comparator.reverseOrder()).forEach(path -> {
                    try {
                        Files.delete(path);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                });
            }
        }
        if (Files.exists(hostDestination, new LinkOption[0]) && !Files.isDirectory(hostDestination, new LinkOption[0])) {
            Files.delete(hostDestination);
        }
        if (Files.exists(hostDestination, new LinkOption[0])) {
            List tempDestFiles;
            try (Stream<Path> stream = Files.list(tempDestination);){
                tempDestFiles = stream.collect(Collectors.toList());
            }
            for (Path it : tempDestFiles) {
                Path relativePath = tempDestination.relativize(it);
                Path destFile = hostDestination.resolve(relativePath);
                Files.move(it, destFile, new CopyOption[0]);
            }
        } else {
            Files.move(tempDestination, hostDestination, new CopyOption[0]);
        }
    }
}

