/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.tasks.image;

import com.bmuschko.gradle.docker.shaded.javax.annotation.Nullable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.gradle.api.DefaultTask;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public class Dockerfile
extends DefaultTask {
    private final ListProperty<Instruction> instructions = this.getProject().getObjects().listProperty(Instruction.class);
    private final RegularFileProperty destFile = this.getProject().getObjects().fileProperty();
    private final ObjectFactory objects;

    @OutputFile
    public final RegularFileProperty getDestFile() {
        return this.destFile;
    }

    public Dockerfile() {
        this.destFile.convention(this.getProject().getLayout().getBuildDirectory().file("docker/Dockerfile"));
        this.objects = this.getProject().getObjects();
    }

    @Nested
    public ListProperty<Instruction> getInstructions() {
        return this.instructions;
    }

    @Internal
    public Provider<Directory> getDestDir() {
        return this.destFile.flatMap((Transformer)new Transformer<Provider<Directory>, RegularFile>(){

            public Provider<Directory> transform(RegularFile f) {
                DirectoryProperty destDir = Dockerfile.this.objects.directoryProperty();
                destDir.set(f.getAsFile().getParentFile());
                return destDir;
            }
        });
    }

    @TaskAction
    public void create() throws IOException {
        this.verifyValidInstructions();
        try (PrintWriter out = new PrintWriter(((RegularFile)this.destFile.get()).getAsFile());){
            ((List)this.instructions.get()).forEach(instruction -> {
                String instructionText = instruction.getText();
                if (instructionText != null && !instructionText.isEmpty()) {
                    out.println(instructionText);
                }
            });
        }
    }

    private void verifyValidInstructions() {
        ArrayList<Instruction> allInstructions = new ArrayList<Instruction>((Collection)this.instructions.get());
        allInstructions.removeIf(it -> {
            String text = it.getText();
            if (text == null) {
                return false;
            }
            return text.startsWith("#");
        });
        if (allInstructions.isEmpty()) {
            throw new IllegalStateException("Please specify instructions for your Dockerfile");
        }
        int fromPos = IntStream.range(0, allInstructions.size()).filter(index -> {
            Instruction it = (Instruction)allInstructions.get(index);
            return it.getKeyword().equals("FROM");
        }).findFirst().orElse(-1);
        int othersPos = IntStream.range(0, allInstructions.size()).filter(index -> {
            Instruction it = (Instruction)allInstructions.get(index);
            return !it.getKeyword().equals("ARG") && !it.getKeyword().equals("FROM");
        }).findFirst().orElse(-1);
        if (fromPos < 0 || othersPos >= 0 && fromPos > othersPos) {
            throw new IllegalStateException("The first instruction of a Dockerfile has to be FROM (or ARG for Docker later than 17.05)");
        }
    }

    public void instructionsFromTemplate(java.io.File template) throws IOException {
        if (!template.exists()) {
            throw new FileNotFoundException("docker template file not found at location : " + template.getAbsolutePath());
        }
        try (Stream<String> lines = Files.lines(template.toPath());){
            lines.filter(it -> !it.isEmpty()).forEach(instruction -> this.getInstructions().add((Object)new GenericInstruction((String)instruction)));
        }
    }

    public void instructionsFromTemplate(String templatePath) throws IOException {
        this.instructionsFromTemplate(this.getProject().file((Object)templatePath));
    }

    public void instructionsFromTemplate(Provider<RegularFile> provider) throws IOException {
        this.instructionsFromTemplate(((RegularFile)provider.get()).getAsFile());
    }

    public void instruction(String instruction) {
        this.instructions.add((Object)new GenericInstruction(instruction));
    }

    public void instruction(Provider<String> provider) {
        this.instructions.add((Object)new GenericInstruction(provider));
    }

    public void from(String image) {
        this.instructions.add((Object)new FromInstruction(new From(image)));
    }

    public void from(From from) {
        this.instructions.add((Object)new FromInstruction(from));
    }

    public void from(Provider<From> provider) {
        this.instructions.add((Object)new FromInstruction(provider));
    }

    public void arg(String arg) {
        this.instructions.add((Object)new ArgInstruction(arg));
    }

    public void arg(Provider<String> provider) {
        this.instructions.add((Object)new ArgInstruction(provider));
    }

    public void runCommand(String command) {
        this.instructions.add((Object)new RunCommandInstruction(command));
    }

    public void runCommand(Provider<String> provider) {
        this.instructions.add((Object)new RunCommandInstruction(provider));
    }

    public void defaultCommand(String ... command) {
        this.instructions.add((Object)new DefaultCommandInstruction(command));
    }

    public void defaultCommand(Provider<List<String>> provider) {
        this.instructions.add((Object)new DefaultCommandInstruction(provider));
    }

    public void exposePort(Integer ... ports) {
        this.instructions.add((Object)new ExposePortInstruction(ports));
    }

    public void exposePort(Provider<List<Integer>> provider) {
        this.instructions.add((Object)new ExposePortInstruction(provider));
    }

    public void environmentVariable(String key, String value) {
        this.instructions.add((Object)new EnvironmentVariableInstruction(key, value));
    }

    public void environmentVariable(Map<String, String> envVars) {
        this.instructions.add((Object)new EnvironmentVariableInstruction(envVars));
    }

    public void environmentVariable(Provider<Map<String, String>> provider) {
        this.instructions.add((Object)new EnvironmentVariableInstruction(provider));
    }

    public void addFile(String src, String dest) {
        this.addFile(new File(src, dest));
    }

    public void addFile(File file) {
        this.instructions.add((Object)new AddFileInstruction(file));
    }

    public void addFile(Provider<File> provider) {
        this.instructions.add((Object)new AddFileInstruction(provider));
    }

    public void copyFile(String src, String dest) {
        this.copyFile(new CopyFile(src, dest));
    }

    public void copyFile(CopyFile file) {
        this.instructions.add((Object)new CopyFileInstruction(file));
    }

    public void copyFile(Provider<CopyFile> provider) {
        this.instructions.add((Object)new CopyFileInstruction(provider));
    }

    public void entryPoint(String ... entryPoint) {
        this.instructions.add((Object)new EntryPointInstruction(entryPoint));
    }

    public void entryPoint(Provider<List<String>> provider) {
        this.instructions.add((Object)new EntryPointInstruction(provider));
    }

    public void volume(String ... volume) {
        this.instructions.add((Object)new VolumeInstruction(volume));
    }

    public void volume(Provider<List<String>> provider) {
        this.instructions.add((Object)new VolumeInstruction(provider));
    }

    public void user(String user) {
        this.instructions.add((Object)new UserInstruction(user));
    }

    public void user(Provider<String> provider) {
        this.instructions.add((Object)new UserInstruction(provider));
    }

    public void workingDir(String dir) {
        this.instructions.add((Object)new WorkDirInstruction(dir));
    }

    public void workingDir(Provider<String> provider) {
        this.instructions.add((Object)new WorkDirInstruction(provider));
    }

    public void onBuild(String instruction) {
        this.instructions.add((Object)new OnBuildInstruction(instruction));
    }

    public void onBuild(Provider<String> provider) {
        this.instructions.add((Object)new OnBuildInstruction(provider));
    }

    public void label(Map<String, String> labels) {
        this.instructions.add((Object)new LabelInstruction((Map)labels));
    }

    public void label(Provider<Map<String, String>> provider) {
        this.instructions.add((Object)new LabelInstruction(provider));
    }

    public static interface Instruction {
        @Internal
        @Nullable
        public String getKeyword();

        @Input
        @Optional
        @Nullable
        public String getText();
    }

    public static class FromInstruction
    implements Instruction {
        public static final String KEYWORD = "FROM";
        private final Provider<From> provider;

        public FromInstruction(From from) {
            this.provider = Providers.ofNullable((Object)from);
        }

        public FromInstruction(Provider<From> provider) {
            this.provider = provider;
        }

        @Override
        public String getKeyword() {
            return KEYWORD;
        }

        @Override
        public String getText() {
            return this.buildTextInstruction((From)this.provider.getOrNull());
        }

        private String buildTextInstruction(From from) {
            if (from != null) {
                Object result = this.getKeyword();
                if (from.getPlatform() != null) {
                    result = (String)result + " --platform=" + from.getPlatform();
                }
                result = (String)result + " " + from.getImage();
                if (from.getStage() != null) {
                    result = (String)result + " AS " + from.getStage();
                }
                return result;
            }
            return null;
        }
    }

    public static class ArgInstruction
    extends StringCommandInstruction {
        public static final String KEYWORD = "ARG";

        public ArgInstruction(String arg) {
            super(arg);
        }

        public ArgInstruction(Provider<String> provider) {
            super(provider);
        }

        @Override
        public String getKeyword() {
            return KEYWORD;
        }
    }

    public static class GenericInstruction
    implements Instruction {
        private final Provider<String> instructionProvider;

        public GenericInstruction(String instruction) {
            this.instructionProvider = Providers.ofNullable((Object)instruction);
        }

        public GenericInstruction(Provider<String> instructionProvider) {
            this.instructionProvider = instructionProvider;
        }

        @Override
        public String getKeyword() {
            return this.parseKeyword((String)this.instructionProvider.getOrNull());
        }

        private String parseKeyword(String inst) {
            return inst.substring(0, inst.indexOf(" "));
        }

        @Override
        public String getText() {
            return (String)this.instructionProvider.getOrNull();
        }
    }

    public static class From {
        private final String image;
        @Nullable
        private String stage;
        @Nullable
        private String platform;

        public From(String image) {
            this.image = image;
        }

        public From withStage(String stage) {
            this.stage = stage;
            return this;
        }

        public From withPlatform(String platform) {
            this.platform = platform;
            return this;
        }

        public String getImage() {
            return this.image;
        }

        @Nullable
        public String getStage() {
            return this.stage;
        }

        @Nullable
        public String getPlatform() {
            return this.platform;
        }
    }

    public static class RunCommandInstruction
    extends StringCommandInstruction {
        public static final String KEYWORD = "RUN";

        public RunCommandInstruction(String command) {
            super(command);
        }

        public RunCommandInstruction(Provider<String> provider) {
            super(provider);
        }

        @Override
        public String getKeyword() {
            return KEYWORD;
        }
    }

    public static class DefaultCommandInstruction
    extends StringArrayInstruction {
        public static final String KEYWORD = "CMD";

        public DefaultCommandInstruction(String ... command) {
            super(command);
        }

        public DefaultCommandInstruction(Provider<List<String>> provider) {
            super(provider);
        }

        @Override
        public String getKeyword() {
            return KEYWORD;
        }
    }

    public static class ExposePortInstruction
    implements Instruction {
        public static final String KEYWORD = "EXPOSE";
        private final Provider<List<Integer>> provider;

        public ExposePortInstruction(Integer ... ports) {
            this.provider = Providers.ofNullable(new ArrayList<Integer>(List.of(ports)));
        }

        public ExposePortInstruction(Provider<List<Integer>> provider) {
            this.provider = provider;
        }

        @Override
        public String getKeyword() {
            return KEYWORD;
        }

        @Override
        public String getText() {
            List evaluatedPorts = (List)this.provider.getOrNull();
            if (evaluatedPorts != null && !evaluatedPorts.isEmpty()) {
                return this.buildText(evaluatedPorts);
            }
            return null;
        }

        private String buildText(List<Integer> ports) {
            return this.getKeyword() + " " + ports.stream().map(Object::toString).collect(Collectors.joining(" "));
        }
    }

    public static class EnvironmentVariableInstruction
    extends MapInstruction {
        public static final String KEYWORD = "ENV";

        public EnvironmentVariableInstruction(String key, String value) {
            super(new HashMap<String, String>(Map.of(key, value)));
        }

        public EnvironmentVariableInstruction(Map<String, String> envVars) {
            super(envVars);
        }

        public EnvironmentVariableInstruction(Provider<Map<String, String>> provider) {
            super(provider);
        }

        @Override
        public String getKeyword() {
            return KEYWORD;
        }
    }

    public static class File {
        private final String src;
        private final String dest;
        @Nullable
        private String chown;

        public File(String src, String dest) {
            this.src = src;
            this.dest = dest;
        }

        public File withChown(String chown) {
            this.chown = chown;
            return this;
        }

        public String getSrc() {
            return this.src;
        }

        public String getDest() {
            return this.dest;
        }

        @Nullable
        public String getChown() {
            return this.chown;
        }
    }

    public static class AddFileInstruction
    extends FileInstruction<File> {
        public static final String KEYWORD = "ADD";

        public AddFileInstruction(File file) {
            super(file);
        }

        public AddFileInstruction(Provider<File> provider) {
            super(provider);
        }

        @Override
        public String getKeyword() {
            return KEYWORD;
        }
    }

    public static class CopyFile
    extends File {
        @Nullable
        private String stage;

        public CopyFile(String src, String dest) {
            super(src, dest);
        }

        public CopyFile withStage(String stage) {
            this.stage = stage;
            return this;
        }

        @Nullable
        public String getStage() {
            return this.stage;
        }
    }

    public static class CopyFileInstruction
    extends FileInstruction<CopyFile> {
        public static final String KEYWORD = "COPY";

        public CopyFileInstruction(CopyFile file) {
            super(file);
        }

        public CopyFileInstruction(Provider<CopyFile> provider) {
            super(provider);
        }

        @Override
        public String getText() {
            Object text = super.getText();
            if (this.getFile() != null && ((CopyFile)this.getFile()).getStage() != null) {
                int keywordIndex = this.getKeyword().length();
                text = ((String)text).substring(0, keywordIndex) + " --from=" + ((CopyFile)this.getFile()).getStage() + ((String)text).substring(keywordIndex, ((String)text).length());
            }
            return text;
        }

        @Override
        public String getKeyword() {
            return KEYWORD;
        }
    }

    public static class EntryPointInstruction
    extends StringArrayInstruction {
        public static final String KEYWORD = "ENTRYPOINT";

        public EntryPointInstruction(String ... entryPoint) {
            super(entryPoint);
        }

        public EntryPointInstruction(Provider<List<String>> provider) {
            super(provider);
        }

        @Override
        public String getKeyword() {
            return KEYWORD;
        }
    }

    public static class VolumeInstruction
    extends StringArrayInstruction {
        public static final String KEYWORD = "VOLUME";

        public VolumeInstruction(String ... volume) {
            super(volume);
        }

        public VolumeInstruction(Provider<List<String>> provider) {
            super(provider);
        }

        @Override
        public String getKeyword() {
            return KEYWORD;
        }
    }

    public static class UserInstruction
    extends StringCommandInstruction {
        public static final String KEYWORD = "USER";

        public UserInstruction(String user) {
            super(user);
        }

        public UserInstruction(Provider<String> provider) {
            super(provider);
        }

        @Override
        public String getKeyword() {
            return KEYWORD;
        }
    }

    public static class WorkDirInstruction
    extends StringCommandInstruction {
        public static final String KEYWORD = "WORKDIR";

        public WorkDirInstruction(String dir) {
            super(dir);
        }

        public WorkDirInstruction(Provider<String> provider) {
            super(provider);
        }

        @Override
        public String getKeyword() {
            return KEYWORD;
        }
    }

    public static class OnBuildInstruction
    extends StringCommandInstruction {
        public static final String KEYWORD = "ONBUILD";

        public OnBuildInstruction(String instruction) {
            super(instruction);
        }

        public OnBuildInstruction(Provider<String> provider) {
            super(provider);
        }

        @Override
        public String getKeyword() {
            return KEYWORD;
        }
    }

    public static class LabelInstruction
    extends MapInstruction {
        public static final String KEYWORD = "LABEL";

        public LabelInstruction(Map labels) {
            super(labels);
        }

        public LabelInstruction(Provider<Map<String, String>> provider) {
            super(provider);
        }

        @Override
        public String getKeyword() {
            return KEYWORD;
        }
    }

    public static class CommentInstruction
    extends StringCommandInstruction {
        public static final String KEYWORD = "#";

        public CommentInstruction(String command) {
            super(command);
        }

        public CommentInstruction(Provider<String> commandProvider) {
            super(commandProvider);
        }

        @Override
        public String getKeyword() {
            return KEYWORD;
        }
    }

    public static abstract class FileInstruction<T extends File>
    implements Instruction {
        private final Provider<T> provider;

        public FileInstruction(T file) {
            this.provider = Providers.ofNullable(file);
        }

        public FileInstruction(Provider<T> provider) {
            this.provider = provider;
        }

        @Internal
        public T getFile() {
            return (T)((File)this.provider.getOrNull());
        }

        @Override
        public String getText() {
            T fileValue = this.getFile();
            if (fileValue != null) {
                StringBuilder instruction = new StringBuilder(this.getKeyword());
                if (((File)fileValue).getChown() != null) {
                    instruction.append(" --chown=" + ((File)fileValue).getChown());
                }
                if (((File)fileValue).getSrc() != null && ((File)fileValue).getDest() != null) {
                    instruction.append(" " + ((File)fileValue).getSrc() + " " + ((File)fileValue).getDest());
                }
                return instruction.toString();
            }
            return null;
        }
    }

    public static abstract class MapInstruction
    implements Instruction {
        private final Provider<Map<String, String>> commandProvider;
        private final ItemJoiner joiner;

        public MapInstruction(Map<String, String> command) {
            this.commandProvider = Providers.ofNullable(command);
            this.joiner = new MultiItemJoiner();
        }

        public MapInstruction(Provider<Map<String, String>> commandProvider) {
            this.commandProvider = commandProvider;
            this.joiner = new MultiItemJoiner();
        }

        @Override
        public String getText() {
            Map evaluatedCommand = (Map)this.commandProvider.getOrNull();
            if (evaluatedCommand == null) {
                throw new IllegalArgumentException("instruction has to be set for " + this.getKeyword());
            }
            this.validateKeysAreNotBlank(evaluatedCommand);
            return this.getKeyword() + " " + this.joiner.join(evaluatedCommand);
        }

        private void validateKeysAreNotBlank(Map<String, String> command) throws IllegalArgumentException {
            command.entrySet().forEach(entry -> {
                if (((String)entry.getKey()).trim().length() == 0) {
                    throw new IllegalArgumentException("blank keys for a key=value pair are not allowed: please check instruction " + this.getKeyword() + " and given pair `" + String.valueOf(entry) + "`");
                }
            });
        }
    }

    private static class ItemJoinerUtil {
        private ItemJoinerUtil() {
        }

        protected static boolean isUnquotedStringWithWhitespaces(String str) {
            return !str.matches("[\"].*[\"]") && str.matches(".*(?: |(?:\r?\n)).*");
        }

        protected static String toQuotedString(String str) {
            return "\"".concat(str.replaceAll("\"", "\\\\\"")).concat("\"");
        }
    }

    private static class MultiItemJoiner
    implements ItemJoiner {
        private MultiItemJoiner() {
        }

        @Override
        public String join(Map<String, String> map) {
            return map.entrySet().stream().map(entry -> {
                String key = ItemJoinerUtil.isUnquotedStringWithWhitespaces((String)entry.getKey()) ? ItemJoinerUtil.toQuotedString((String)entry.getKey()) : (String)entry.getKey();
                String value = ItemJoinerUtil.isUnquotedStringWithWhitespaces((String)entry.getValue()) ? ItemJoinerUtil.toQuotedString((String)entry.getValue()) : (String)entry.getValue();
                value = value.replaceAll("(\r)*\n", "\\\\\n");
                return key + "=" + value;
            }).collect(Collectors.joining(" "));
        }
    }

    private static interface ItemJoiner {
        public String join(Map<String, String> var1);
    }

    public static abstract class StringArrayInstruction
    implements Instruction {
        private final Provider<List<String>> commandProvider;

        public StringArrayInstruction(String ... command) {
            this.commandProvider = Providers.ofNullable(new ArrayList<String>(List.of(command)));
        }

        public StringArrayInstruction(Provider<List<String>> commandProvider) {
            this.commandProvider = commandProvider;
        }

        @Override
        public String getText() {
            List command = (List)this.commandProvider.getOrNull();
            if (command != null && !command.isEmpty()) {
                return this.buildText(command);
            }
            return null;
        }

        private String buildText(List<String> command) {
            return this.getKeyword() + " [\"" + String.join((CharSequence)"\", \"", command) + "\"]";
        }
    }

    public static abstract class StringCommandInstruction
    implements Instruction {
        private final Provider<String> commandProvider;

        public StringCommandInstruction(String command) {
            this.commandProvider = Providers.ofNullable((Object)command);
        }

        public StringCommandInstruction(Provider<String> commandProvider) {
            this.commandProvider = commandProvider;
        }

        @Override
        public String getText() {
            String command = (String)this.commandProvider.getOrNull();
            if (command != null) {
                return this.buildText(command);
            }
            return null;
        }

        private String buildText(String command) {
            return this.getKeyword() + " " + command;
        }
    }
}

