/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.tasks.image;

import com.bmuschko.gradle.docker.tasks.AbstractDockerRemoteApiTask;
import com.github.dockerjava.api.command.ListImagesCmd;
import com.github.dockerjava.api.model.Image;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;

public class DockerListImages
extends AbstractDockerRemoteApiTask {
    private final Property<Boolean> showAll = this.getProject().getObjects().property(Boolean.class);
    private final Property<Boolean> dangling = this.getProject().getObjects().property(Boolean.class);
    private final MapProperty<String, String> labels = this.getProject().getObjects().mapProperty(String.class, String.class);
    private final Property<String> imageName = this.getProject().getObjects().property(String.class);

    @Input
    @Optional
    public final Property<Boolean> getShowAll() {
        return this.showAll;
    }

    @Input
    @Optional
    public final Property<Boolean> getDangling() {
        return this.dangling;
    }

    @Input
    @Optional
    public final MapProperty<String, String> getLabels() {
        return this.labels;
    }

    @Input
    @Optional
    public final Property<String> getImageName() {
        return this.imageName;
    }

    public DockerListImages() {
        this.defaultResponseHandling();
    }

    @Override
    public void runRemoteCommand() {
        ListImagesCmd listImagesCmd = this.getDockerClient().listImagesCmd();
        if (Boolean.TRUE.equals(this.showAll.getOrNull())) {
            listImagesCmd.withShowAll((Boolean)this.showAll.get());
        }
        if (Boolean.TRUE.equals(this.dangling.getOrNull())) {
            listImagesCmd.withDanglingFilter((Boolean)this.dangling.get());
        }
        if (this.labels.getOrNull() != null && !((Map)this.labels.get()).isEmpty()) {
            listImagesCmd.withLabelFilter((Map)this.labels.get());
        }
        if (this.imageName.getOrNull() != null && !((String)this.imageName.get()).isEmpty()) {
            listImagesCmd.withImageNameFilter((String)this.imageName.get());
        }
        List images = (List)listImagesCmd.exec();
        if (this.getNextHandler() != null) {
            for (Image image : images) {
                this.getNextHandler().execute((Object)image);
            }
        }
    }

    private void defaultResponseHandling() {
        Action action = image -> {
            this.getLogger().quiet("Repository Tags : " + Arrays.stream(image.getRepoTags()).filter(Objects::nonNull).collect(Collectors.joining(", ")));
            this.getLogger().quiet("Image ID        : " + image.getId());
            this.getLogger().quiet("Created         : " + new Date(image.getCreated() * 1000L));
            this.getLogger().quiet("Virtual Size    : " + image.getVirtualSize());
            this.getLogger().quiet("-----------------------------------------------");
        };
        this.onNext(action);
    }
}

