/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.shaded.org.bouncycastle.cms.jcajce;

import com.bmuschko.gradle.docker.shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.cms.CMSException;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.cms.KeyTransRecipientId;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.cms.RecipientOperator;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.cms.jcajce.JceKTSKeyTransRecipient;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.jcajce.io.MacOutputStream;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.operator.GenericKey;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.operator.MacCalculator;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.operator.jcajce.JceGenericKey;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import java.security.PrivateKey;
import javax.crypto.Mac;

public class JceKTSKeyTransAuthenticatedRecipient
extends JceKTSKeyTransRecipient {
    public JceKTSKeyTransAuthenticatedRecipient(PrivateKey privateKey, KeyTransRecipientId keyTransRecipientId) throws IOException {
        super(privateKey, JceKTSKeyTransAuthenticatedRecipient.getPartyVInfoFromRID(keyTransRecipientId));
    }

    @Override
    public RecipientOperator getRecipientOperator(AlgorithmIdentifier algorithmIdentifier, final AlgorithmIdentifier algorithmIdentifier2, byte[] byArray) throws CMSException {
        final Key key = this.extractSecretKey(algorithmIdentifier, algorithmIdentifier2, byArray);
        final Mac mac = this.contentHelper.createContentMac(key, algorithmIdentifier2);
        return new RecipientOperator(new MacCalculator(){

            @Override
            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return algorithmIdentifier2;
            }

            @Override
            public GenericKey getKey() {
                return new JceGenericKey(algorithmIdentifier2, key);
            }

            @Override
            public OutputStream getOutputStream() {
                return new MacOutputStream(mac);
            }

            @Override
            public byte[] getMac() {
                return mac.doFinal();
            }
        });
    }
}

