/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker;

import com.bmuschko.gradle.docker.DockerRegistryCredentials;
import com.bmuschko.gradle.docker.internal.DefaultDockerConfigResolver;
import com.bmuschko.gradle.docker.internal.DefaultDockerUrlValueSource;
import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;

public class DockerExtension {
    private final Property<String> url;
    private final DirectoryProperty certPath;
    private final Property<String> apiVersion;
    private final DockerRegistryCredentials registryCredentials;

    public final Property<String> getUrl() {
        return this.url;
    }

    public final DirectoryProperty getCertPath() {
        return this.certPath;
    }

    public final Property<String> getApiVersion() {
        return this.apiVersion;
    }

    public final DockerRegistryCredentials getRegistryCredentials() {
        return this.registryCredentials;
    }

    public DockerExtension(ObjectFactory objectFactory, ProviderFactory providerFactory) {
        DefaultDockerConfigResolver dockerConfigResolver = new DefaultDockerConfigResolver();
        this.url = objectFactory.property(String.class);
        this.url.convention(providerFactory.of(DefaultDockerUrlValueSource.class, noneValueSourceSpec -> {}));
        this.certPath = objectFactory.directoryProperty();
        File defaultDockerCert = dockerConfigResolver.getDefaultDockerCert();
        if (defaultDockerCert != null) {
            this.certPath.convention((Provider)objectFactory.directoryProperty().fileValue(defaultDockerCert));
        }
        this.apiVersion = objectFactory.property(String.class);
        this.registryCredentials = (DockerRegistryCredentials)objectFactory.newInstance(DockerRegistryCredentials.class, new Object[]{objectFactory});
    }

    public void registryCredentials(Action<? super DockerRegistryCredentials> action) {
        action.execute((Object)this.registryCredentials);
    }
}

