/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.tasks.image;

import com.bmuschko.gradle.docker.tasks.image.DockerExistingImage;
import com.github.dockerjava.api.command.InspectImageResponse;
import org.gradle.api.Action;

public class DockerInspectImage
extends DockerExistingImage {
    public DockerInspectImage() {
        this.defaultResponseHandling();
    }

    @Override
    public void runRemoteCommand() {
        this.getLogger().quiet("Inspecting image with ID '" + (String)this.getImageId().get() + "'.");
        InspectImageResponse image = this.getDockerClient().inspectImageCmd((String)this.getImageId().get()).exec();
        if (this.getNextHandler() != null) {
            this.getNextHandler().execute((Object)image);
        }
    }

    private void defaultResponseHandling() {
        Action action = image -> {
            this.getLogger().quiet("ID               : " + image.getId());
            this.getLogger().quiet("Author           : " + image.getAuthor());
            this.getLogger().quiet("Created          : " + image.getCreated());
            this.getLogger().quiet("Comment          : " + image.getComment());
            this.getLogger().quiet("Architecture     : " + image.getArch());
            this.getLogger().quiet("Operating System : " + image.getOs());
            this.getLogger().quiet("Parent           : " + image.getParent());
            this.getLogger().quiet("Size             : " + image.getSize());
            this.getLogger().quiet("Docker Version   : " + image.getDockerVersion());
            this.getLogger().quiet("Labels           : " + image.getConfig().getLabels());
        };
        this.onNext(action);
    }
}

