/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.tasks.image;

import com.bmuschko.gradle.docker.DockerRegistryCredentials;
import com.bmuschko.gradle.docker.internal.OutputCollector;
import com.bmuschko.gradle.docker.internal.RegularFileToStringTransformer;
import com.bmuschko.gradle.docker.tasks.AbstractDockerRemoteApiTask;
import com.bmuschko.gradle.docker.tasks.RegistryCredentialsAware;
import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.api.command.BuildImageResultCallback;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.AuthConfigurations;
import com.github.dockerjava.api.model.BuildResponseItem;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;

public class DockerBuildImage
extends AbstractDockerRemoteApiTask
implements RegistryCredentialsAware {
    private final DirectoryProperty inputDir = this.getProject().getObjects().directoryProperty();
    private final RegularFileProperty dockerFile = this.getProject().getObjects().fileProperty();
    private final SetProperty<String> images = this.getProject().getObjects().setProperty(String.class);
    private final Property<Boolean> noCache = this.getProject().getObjects().property(Boolean.class);
    private final Property<Boolean> remove = this.getProject().getObjects().property(Boolean.class);
    private final Property<Boolean> quiet = this.getProject().getObjects().property(Boolean.class);
    private final Property<Boolean> pull = this.getProject().getObjects().property(Boolean.class);
    private MapProperty<String, String> labels = this.getProject().getObjects().mapProperty(String.class, String.class);
    private final Property<String> network = this.getProject().getObjects().property(String.class);
    private final MapProperty<String, String> buildArgs = this.getProject().getObjects().mapProperty(String.class, String.class);
    private final SetProperty<String> cacheFrom = this.getProject().getObjects().setProperty(String.class);
    private final Property<Long> shmSize = this.getProject().getObjects().property(Long.class);
    private final Property<Long> memory = this.getProject().getObjects().property(Long.class);
    private final Property<String> target = this.getProject().getObjects().property(String.class);
    private final SetProperty<String> extraHosts = this.getProject().getObjects().setProperty(String.class);
    private final Property<String> platform = this.getProject().getObjects().property(String.class);
    private final DockerRegistryCredentials registryCredentials;
    private final RegularFileProperty imageIdFile = this.getProject().getObjects().fileProperty();
    private final Property<String> imageId = this.getProject().getObjects().property(String.class);
    private final Spec<Task> upToDateWhenSpec = new Spec<Task>(){

        public boolean isSatisfiedBy(Task element) {
            File file = ((RegularFile)DockerBuildImage.this.getImageIdFile().get()).getAsFile();
            if (file.exists()) {
                try {
                    String fileImageId;
                    try {
                        fileImageId = Files.readString(file.toPath());
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    List<String> repoTags = DockerBuildImage.this.getDockerClient().inspectImageCmd(fileImageId).exec().getRepoTags();
                    if (!DockerBuildImage.this.getImages().isPresent() || repoTags.containsAll((Collection)DockerBuildImage.this.getImages().get())) {
                        return true;
                    }
                }
                catch (DockerException dockerException) {
                    // empty catch block
                }
            }
            return false;
        }
    };

    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public final DirectoryProperty getInputDir() {
        return this.inputDir;
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    public final RegularFileProperty getDockerFile() {
        return this.dockerFile;
    }

    @Input
    @Optional
    public final SetProperty<String> getImages() {
        return this.images;
    }

    @Input
    @Optional
    public final Property<Boolean> getNoCache() {
        return this.noCache;
    }

    @Input
    @Optional
    public final Property<Boolean> getRemove() {
        return this.remove;
    }

    @Input
    @Optional
    public final Property<Boolean> getQuiet() {
        return this.quiet;
    }

    @Input
    @Optional
    public final Property<Boolean> getPull() {
        return this.pull;
    }

    @Input
    @Optional
    public MapProperty<String, String> getLabels() {
        return this.labels;
    }

    @Input
    @Optional
    public final Property<String> getNetwork() {
        return this.network;
    }

    @Input
    @Optional
    public final MapProperty<String, String> getBuildArgs() {
        return this.buildArgs;
    }

    @Input
    @Optional
    public final SetProperty<String> getCacheFrom() {
        return this.cacheFrom;
    }

    @Input
    @Optional
    public final Property<Long> getShmSize() {
        return this.shmSize;
    }

    @Input
    @Optional
    public final Property<Long> getMemory() {
        return this.memory;
    }

    @Input
    @Optional
    public final Property<String> getTarget() {
        return this.target;
    }

    @Input
    @Optional
    public final SetProperty<String> getExtraHosts() {
        return this.extraHosts;
    }

    @Input
    @Optional
    public final Property<String> getPlatform() {
        return this.platform;
    }

    @Override
    public final DockerRegistryCredentials getRegistryCredentials() {
        return this.registryCredentials;
    }

    @OutputFile
    public final RegularFileProperty getImageIdFile() {
        return this.imageIdFile;
    }

    @Internal
    public final Property<String> getImageId() {
        return this.imageId;
    }

    public DockerBuildImage() {
        this.inputDir.convention(this.getProject().getLayout().getBuildDirectory().dir("docker"));
        this.noCache.convention((Object)false);
        this.remove.convention((Object)false);
        this.quiet.convention((Object)false);
        this.pull.convention((Object)false);
        this.imageId.convention(this.imageIdFile.map((Transformer)new RegularFileToStringTransformer()));
        String safeTaskPath = this.getPath().replaceFirst("^:", "").replaceAll(":", "_");
        this.registryCredentials = (DockerRegistryCredentials)this.getProject().getObjects().newInstance(DockerRegistryCredentials.class, new Object[]{this.getProject().getObjects()});
        this.imageIdFile.convention(this.getProject().getLayout().getBuildDirectory().file(".docker/" + safeTaskPath + "-imageId.txt"));
        this.getOutputs().upToDateWhen(this.upToDateWhenSpec);
    }

    @Override
    public void runRemoteCommand() throws Exception {
        BuildImageCmd buildImageCmd;
        this.getLogger().quiet("Building image using context '" + ((Directory)this.getInputDir().get()).getAsFile() + "'.");
        if (this.dockerFile.getOrNull() != null) {
            this.getLogger().quiet("Using Dockerfile '" + ((RegularFile)this.getDockerFile().get()).getAsFile() + "'");
            buildImageCmd = this.getDockerClient().buildImageCmd().withBaseDirectory(((Directory)this.inputDir.get()).getAsFile()).withDockerfile(((RegularFile)this.dockerFile.get()).getAsFile());
        } else {
            buildImageCmd = this.getDockerClient().buildImageCmd(((Directory)this.inputDir.get()).getAsFile());
        }
        if (this.images.getOrNull() != null && !((Set)this.images.get()).isEmpty()) {
            String tagListString = ((Set)this.images.get()).stream().map(it -> "'" + it + "'").collect(Collectors.joining(", "));
            this.getLogger().quiet("Using images " + tagListString + ".");
            buildImageCmd.withTags((Set)this.images.get());
        }
        if (Boolean.TRUE.equals(this.noCache.getOrNull())) {
            buildImageCmd.withNoCache((Boolean)this.noCache.get());
        }
        if (Boolean.TRUE.equals(this.remove.getOrNull())) {
            buildImageCmd.withRemove((Boolean)this.remove.get());
        }
        if (Boolean.TRUE.equals(this.quiet.getOrNull())) {
            buildImageCmd.withQuiet((Boolean)this.quiet.get());
        }
        if (Boolean.TRUE.equals(this.pull.getOrNull())) {
            buildImageCmd.withPull((Boolean)this.pull.get());
        }
        if (this.network.getOrNull() != null) {
            buildImageCmd.withNetworkMode((String)this.network.get());
        }
        if (this.labels.getOrNull() != null && !((Map)this.labels.get()).isEmpty()) {
            buildImageCmd.withLabels((Map)this.labels.get());
        }
        if (this.shmSize.getOrNull() != null) {
            buildImageCmd.withShmsize((Long)this.shmSize.get());
        }
        if (this.memory.getOrNull() != null) {
            buildImageCmd.withMemory((Long)this.memory.get());
        }
        if (this.target.getOrNull() != null) {
            buildImageCmd.withTarget((String)this.target.get());
        }
        if (this.platform.getOrNull() != null) {
            buildImageCmd.withPlatform((String)this.platform.get());
        }
        AuthConfigurations authConfigurations = this.getRegistryAuthLocator().lookupAllAuthConfigs(this.registryCredentials);
        buildImageCmd.withBuildAuthConfigs(authConfigurations);
        if (this.buildArgs.getOrNull() != null && !((Map)this.buildArgs.get()).isEmpty()) {
            for (Map.Entry entry : ((Map)this.buildArgs.get()).entrySet()) {
                buildImageCmd.withBuildArg((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.cacheFrom.getOrNull() != null && !((Set)this.cacheFrom.get()).isEmpty()) {
            buildImageCmd.withCacheFrom((Set)this.cacheFrom.get());
        }
        if (this.extraHosts.getOrNull() != null && !((Set)this.extraHosts.get()).isEmpty()) {
            buildImageCmd.withExtraHosts((Set)this.extraHosts.get());
        }
        String createdImageId = buildImageCmd.exec(this.createCallback((Action<BuildResponseItem>)this.getNextHandler())).awaitImageId();
        ((RegularFile)this.imageIdFile.get()).getAsFile().getParentFile().mkdirs();
        Files.writeString(((RegularFile)this.imageIdFile.get()).getAsFile().toPath(), (CharSequence)createdImageId, new OpenOption[0]);
        this.getLogger().quiet("Created image with ID '" + createdImageId + "'.");
    }

    private BuildImageResultCallback createCallback(final Action<BuildResponseItem> nextHandler) {
        if (nextHandler != null) {
            return new BuildImageResultCallback(){

                @Override
                public void onNext(BuildResponseItem item) {
                    try {
                        nextHandler.execute((Object)item);
                    }
                    catch (Exception e) {
                        DockerBuildImage.this.getLogger().error("Failed to handle build response", (Throwable)e);
                        return;
                    }
                    super.onNext(item);
                }
            };
        }
        return new BuildImageResultCallback(){
            private final OutputCollector collector = new OutputCollector(new Consumer<String>(){

                @Override
                public void accept(String s) {
                    DockerBuildImage.this.getLogger().quiet(s);
                }
            });

            @Override
            public void onNext(BuildResponseItem item) {
                try {
                    String possibleStream = item.getStream();
                    if (possibleStream != null && !possibleStream.isEmpty()) {
                        this.collector.accept(possibleStream);
                    }
                }
                catch (Exception e) {
                    DockerBuildImage.this.getLogger().error("Failed to handle build response", (Throwable)e);
                    return;
                }
                super.onNext(item);
            }

            @Override
            public void close() throws IOException {
                this.collector.close();
                super.close();
            }
        };
    }

    @Override
    public void registryCredentials(Action<? super DockerRegistryCredentials> action) {
        action.execute((Object)this.registryCredentials);
    }
}

