/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker;

import com.bmuschko.gradle.docker.DockerExtension;
import com.bmuschko.gradle.docker.DockerRegistryCredentials;
import com.bmuschko.gradle.docker.internal.services.DockerClientService;
import com.bmuschko.gradle.docker.tasks.AbstractDockerRemoteApiTask;
import com.bmuschko.gradle.docker.tasks.RegistryCredentialsAware;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildServiceSpec;

public class DockerRemoteApiPlugin
implements Plugin<Project> {
    public static final String EXTENSION_NAME = "docker";
    public static final String DEFAULT_TASK_GROUP = "Docker";

    public void apply(Project project) {
        final DockerExtension dockerExtension = (DockerExtension)project.getExtensions().create(EXTENSION_NAME, DockerExtension.class, new Object[]{project.getObjects()});
        this.configureRegistryCredentialsAwareTasks(project, dockerExtension.getRegistryCredentials());
        final Provider serviceProvider = project.getGradle().getSharedServices().registerIfAbsent(EXTENSION_NAME, DockerClientService.class, (Action)new Action<BuildServiceSpec<DockerClientService.Params>>(){

            public void execute(BuildServiceSpec<DockerClientService.Params> pBuildServiceSpec) {
                pBuildServiceSpec.parameters(parameters -> {
                    parameters.getUrl().set(dockerExtension.getUrl());
                    parameters.getCertPath().set((Provider)dockerExtension.getCertPath());
                    parameters.getApiVersion().set(dockerExtension.getApiVersion());
                });
            }
        });
        project.getTasks().withType(AbstractDockerRemoteApiTask.class).configureEach((Action)new Action<AbstractDockerRemoteApiTask>(){

            public void execute(AbstractDockerRemoteApiTask task) {
                task.getDockerClientService().set(serviceProvider);
            }
        });
    }

    private void configureRegistryCredentialsAwareTasks(Project project, final DockerRegistryCredentials extensionRegistryCredentials) {
        project.getTasks().withType(RegistryCredentialsAware.class).configureEach((Action)new Action<RegistryCredentialsAware>(){

            public void execute(RegistryCredentialsAware task) {
                task.getRegistryCredentials().getUrl().convention(extensionRegistryCredentials.getUrl());
                task.getRegistryCredentials().getUsername().convention(extensionRegistryCredentials.getUsername());
                task.getRegistryCredentials().getPassword().convention(extensionRegistryCredentials.getPassword());
                task.getRegistryCredentials().getEmail().convention(extensionRegistryCredentials.getEmail());
            }
        });
    }
}

