/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.internal;

import com.bmuschko.gradle.docker.internal.DockerConfigResolver;
import com.bmuschko.gradle.docker.internal.OsUtils;
import com.bmuschko.gradle.docker.shaded.javax.annotation.Nullable;
import java.io.File;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class DefaultDockerConfigResolver
implements DockerConfigResolver {
    private static final Logger logger = Logging.getLogger(DefaultDockerConfigResolver.class);

    @Override
    public String getDefaultDockerUrl() {
        Object dockerUrl = this.getEnv("DOCKER_HOST");
        if (dockerUrl == null) {
            if (OsUtils.isWindows().booleanValue()) {
                if (this.isFileExists("\\\\.\\pipe\\docker_engine")) {
                    dockerUrl = "npipe:////./pipe/docker_engine";
                }
            } else if (this.isFileExists("/var/run/docker.sock")) {
                dockerUrl = "unix:///var/run/docker.sock";
            } else if (this.isFileExists(System.getProperty("user.home") + "/.docker/run/docker.sock")) {
                dockerUrl = "unix://" + System.getProperty("user.home") + "/.docker/run/docker.sock";
            }
            if (dockerUrl == null) {
                dockerUrl = "tcp://127.0.0.1:2375";
            }
        }
        logger.info("Default docker.url set to " + (String)dockerUrl);
        return dockerUrl;
    }

    @Override
    @Nullable
    public File getDefaultDockerCert() {
        File certFile;
        String dockerCertPath = this.getEnv("DOCKER_CERT_PATH");
        if (dockerCertPath != null && (certFile = new File(dockerCertPath)).exists()) {
            return certFile;
        }
        return null;
    }

    @Nullable
    String getEnv(String name) {
        return System.getenv(name);
    }

    boolean isFileExists(String path) {
        return new File(path).exists();
    }
}

