/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.internal;

import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.CopySpec;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetOutput;

public final class ConventionPluginHelper {
    private ConventionPluginHelper() {
    }

    public static SourceSetOutput getMainJavaSourceSetOutput(Project project) {
        JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        return ((SourceSet)javaPluginExtension.getSourceSets().getByName("main")).getOutput();
    }

    public static CopySpec createAppFilesCopySpec(final Project project) {
        return project.copySpec((Action)new Action<CopySpec>(){

            public void execute(CopySpec rootSpec) {
                rootSpec.into((Object)"libs", (Action)new Action<CopySpec>(){

                    public void execute(CopySpec copySpec) {
                        copySpec.from(new Object[]{ConventionPluginHelper.getRuntimeClasspathConfiguration(project)});
                    }
                });
                rootSpec.into((Object)"resources", (Action)new Action<CopySpec>(){

                    public void execute(CopySpec copySpec) {
                        copySpec.from(new Object[]{ConventionPluginHelper.getMainJavaSourceSetOutput(project).getResourcesDir()});
                    }
                });
                rootSpec.into((Object)"classes", (Action)new Action<CopySpec>(){

                    public void execute(CopySpec copySpec) {
                        copySpec.from(new Object[]{ConventionPluginHelper.getMainJavaSourceSetOutput(project).getClassesDirs()});
                    }
                });
            }
        });
    }

    private static Configuration getRuntimeClasspathConfiguration(Project project) {
        return project.getConfigurations().getByName("runtimeClasspath");
    }
}

