/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker;

import com.bmuschko.gradle.docker.DockerConventionJvmApplicationExtension;
import com.bmuschko.gradle.docker.DockerExtension;
import com.bmuschko.gradle.docker.DockerRemoteApiPlugin;
import com.bmuschko.gradle.docker.internal.ConventionPluginHelper;
import com.bmuschko.gradle.docker.tasks.image.DockerBuildImage;
import com.bmuschko.gradle.docker.tasks.image.DockerPushImage;
import com.bmuschko.gradle.docker.tasks.image.Dockerfile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.Directory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.TaskProvider;

public abstract class DockerConventionJvmApplicationPlugin<EXT extends DockerConventionJvmApplicationExtension>
implements Plugin<Project> {
    public static final String SYNC_BUILD_CONTEXT_TASK_NAME = "dockerSyncBuildContext";
    public static final String DOCKERFILE_TASK_NAME = "dockerCreateDockerfile";
    public static final String BUILD_IMAGE_TASK_NAME = "dockerBuildImage";
    public static final String PUSH_IMAGE_TASK_NAME = "dockerPushImage";

    public void apply(Project project) {
        project.getPlugins().apply(DockerRemoteApiPlugin.class);
        DockerExtension dockerExtension = (DockerExtension)project.getExtensions().getByType(DockerExtension.class);
        EXT extension = this.configureExtension(project.getObjects(), dockerExtension);
        project.getPlugins().withType(JavaPlugin.class).configureEach(javaPlugin -> {
            TaskProvider<Dockerfile> createDockerfileTask = this.registerDockerfileTask(project, extension);
            final TaskProvider<Sync> syncBuildContextTask = DockerConventionJvmApplicationPlugin.registerSyncBuildContextTask(project, createDockerfileTask);
            createDockerfileTask.configure((Action)new Action<Dockerfile>(){

                public void execute(Dockerfile dockerfile) {
                    dockerfile.dependsOn(new Object[]{syncBuildContextTask});
                }
            });
            TaskProvider<DockerBuildImage> dockerBuildImageTask = this.registerBuildImageTask(project, createDockerfileTask, extension);
            DockerConventionJvmApplicationPlugin.registerPushImageTask(project, dockerBuildImageTask);
        });
    }

    private TaskProvider<Dockerfile> registerDockerfileTask(final Project project, final EXT extension) {
        return project.getTasks().register(DOCKERFILE_TASK_NAME, Dockerfile.class, (Action)new Action<Dockerfile>(){

            public void execute(final Dockerfile dockerfile) {
                dockerfile.setGroup("Docker");
                dockerfile.setDescription("Creates the Docker image for the application.");
                dockerfile.from((Provider<Dockerfile.From>)project.provider((Callable)new Callable<Dockerfile.From>(){

                    @Override
                    public Dockerfile.From call() throws Exception {
                        return new Dockerfile.From((String)extension.getBaseImage().get());
                    }
                }));
                dockerfile.label((Provider<Map<String, String>>)project.provider((Callable)new Callable<Map<String, String>>(){

                    @Override
                    public Map<String, String> call() throws Exception {
                        return new HashMap<String, String>(Map.ofEntries(Map.entry("maintainer", (String)extension.getMaintainer().get())));
                    }
                }));
                dockerfile.workingDir("/app");
                dockerfile.copyFile((Provider<Dockerfile.CopyFile>)project.provider((Callable)new Callable<Dockerfile.CopyFile>(){

                    @Override
                    public Dockerfile.CopyFile call() throws Exception {
                        if (new File(((Directory)dockerfile.getDestDir().get()).getAsFile(), "libs").isDirectory()) {
                            return new Dockerfile.CopyFile("libs", "libs/");
                        }
                        return null;
                    }
                }));
                dockerfile.copyFile((Provider<Dockerfile.CopyFile>)project.provider((Callable)new Callable<Dockerfile.CopyFile>(){

                    @Override
                    public Dockerfile.CopyFile call() throws Exception {
                        if (ConventionPluginHelper.getMainJavaSourceSetOutput(project).getResourcesDir().isDirectory()) {
                            return new Dockerfile.CopyFile("resources", "resources/");
                        }
                        return null;
                    }
                }));
                dockerfile.copyFile(new Dockerfile.CopyFile("classes", "classes/"));
                dockerfile.entryPoint((Provider<List<String>>)project.provider((Callable)new Callable<List<String>>(){

                    @Override
                    public List<String> call() throws Exception {
                        ArrayList<String> entrypoint = new ArrayList<String>(List.of("java"));
                        List jvmArgs = (List)extension.getJvmArgs().get();
                        if (!jvmArgs.isEmpty()) {
                            entrypoint.addAll(jvmArgs);
                        }
                        entrypoint.addAll(List.of("-cp", "/app/resources:/app/classes:/app/libs/*", DockerConventionJvmApplicationPlugin.this.getApplicationMainClassName(project, extension)));
                        List args = (List)extension.getArgs().get();
                        if (!args.isEmpty()) {
                            entrypoint.addAll(args);
                        }
                        return entrypoint;
                    }
                }));
                dockerfile.exposePort((Provider<List<Integer>>)extension.getPorts());
            }
        });
    }

    private static TaskProvider<Sync> registerSyncBuildContextTask(final Project project, final TaskProvider<Dockerfile> createDockerfileTask) {
        return project.getTasks().register(SYNC_BUILD_CONTEXT_TASK_NAME, Sync.class, (Action)new Action<Sync>(){

            public void execute(Sync sync) {
                sync.setGroup("Docker");
                sync.setDescription("Copies the distribution resources to a temporary directory for image creation.");
                sync.dependsOn(new Object[]{project.getTasks().getByName("classes")});
                sync.into(((Dockerfile)((Object)createDockerfileTask.get())).getDestDir());
                sync.with(new CopySpec[]{ConventionPluginHelper.createAppFilesCopySpec(project)});
            }
        });
    }

    private TaskProvider<DockerBuildImage> registerBuildImageTask(final Project project, final TaskProvider<Dockerfile> createDockerfileTask, final EXT extension) {
        return project.getTasks().register(BUILD_IMAGE_TASK_NAME, DockerBuildImage.class, (Action)new Action<DockerBuildImage>(){

            public void execute(DockerBuildImage dockerBuildImage) {
                dockerBuildImage.setGroup("Docker");
                dockerBuildImage.setDescription("Builds the Docker image for the application.");
                dockerBuildImage.dependsOn(new Object[]{createDockerfileTask});
                dockerBuildImage.getImages().addAll(DockerConventionJvmApplicationPlugin.this.determineImages(project, extension));
            }
        });
    }

    private Provider<Set<String>> determineImages(final Project project, final EXT extension) {
        return project.provider((Callable)new Callable<Set<String>>(){

            @Override
            public Set<String> call() throws Exception {
                if (extension.getImages().getOrNull() != null && !((Set)extension.getImages().get()).isEmpty()) {
                    return (Set)extension.getImages().get();
                }
                String tagVersion = project.getVersion().equals("unspecified") ? "latest" : project.getVersion().toString();
                String artifactAndVersion = (project.getName() + ":" + tagVersion).toLowerCase();
                return Set.of(!project.getGroup().toString().isEmpty() ? project.getGroup() + "/" + artifactAndVersion : artifactAndVersion);
            }
        });
    }

    private static TaskProvider<DockerPushImage> registerPushImageTask(Project project, final TaskProvider<DockerBuildImage> dockerBuildImageTask) {
        return project.getTasks().register(PUSH_IMAGE_TASK_NAME, DockerPushImage.class, (Action)new Action<DockerPushImage>(){

            public void execute(DockerPushImage pushImage) {
                pushImage.setGroup("Docker");
                pushImage.setDescription("Pushes created Docker image to the repository.");
                pushImage.dependsOn(new Object[]{dockerBuildImageTask});
                pushImage.getImages().convention(((DockerBuildImage)dockerBuildImageTask.get()).getImages());
            }
        });
    }

    private String getApplicationMainClassName(Project project, EXT extension) throws IOException {
        if (((DockerConventionJvmApplicationExtension)extension).getMainClassName().isPresent()) {
            return (String)((DockerConventionJvmApplicationExtension)extension).getMainClassName().get();
        }
        for (File classesDir : ConventionPluginHelper.getMainJavaSourceSetOutput(project).getClassesDirs()) {
            String mainClassName = this.findMainClassName(classesDir);
            if (mainClassName == null) continue;
            return mainClassName;
        }
        throw new IllegalStateException("Main class name could not be resolved");
    }

    protected abstract EXT configureExtension(ObjectFactory var1, DockerExtension var2);

    protected abstract String findMainClassName(File var1) throws IOException;
}

