/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.tasks.image;

import com.bmuschko.gradle.docker.tasks.image.DockerExistingImage;
import com.github.dockerjava.api.command.InspectImageResponse;
import org.gradle.api.Action;

public class DockerInspectImage
extends DockerExistingImage {
    public DockerInspectImage() {
        this.defaultResponseHandling();
    }

    @Override
    public void runRemoteCommand() {
        this.getLogger().quiet("Inspecting image with ID '" + (String)this.getImageId().get() + "'.");
        InspectImageResponse image = this.getDockerClient().inspectImageCmd((String)this.getImageId().get()).exec();
        if (this.getNextHandler() != null) {
            this.getNextHandler().execute((Object)image);
        }
    }

    private void defaultResponseHandling() {
        Action<InspectImageResponse> action = new Action<InspectImageResponse>(){

            public void execute(InspectImageResponse image) {
                DockerInspectImage.this.getLogger().quiet("ID               : " + image.getId());
                DockerInspectImage.this.getLogger().quiet("Author           : " + image.getAuthor());
                DockerInspectImage.this.getLogger().quiet("Created          : " + image.getCreated());
                DockerInspectImage.this.getLogger().quiet("Comment          : " + image.getComment());
                DockerInspectImage.this.getLogger().quiet("Architecture     : " + image.getArch());
                DockerInspectImage.this.getLogger().quiet("Operating System : " + image.getOs());
                DockerInspectImage.this.getLogger().quiet("Parent           : " + image.getParent());
                DockerInspectImage.this.getLogger().quiet("Size             : " + image.getSize());
                DockerInspectImage.this.getLogger().quiet("Docker Version   : " + image.getDockerVersion());
                DockerInspectImage.this.getLogger().quiet("Labels           : " + image.getConfig().getLabels());
            }
        };
        this.onNext((Action)action);
    }
}

