/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.tasks.image;

import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.api.command.TagImageCmd;
import com.bmuschko.gradle.docker.tasks.image.DockerExistingImage;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;

public class DockerTagImage
extends DockerExistingImage {
    private final Property<String> repository = this.getProject().getObjects().property(String.class);
    private final Property<String> tag = this.getProject().getObjects().property(String.class);
    private final Property<Boolean> force = this.getProject().getObjects().property(Boolean.class);

    @Input
    public final Property<String> getRepository() {
        return this.repository;
    }

    @Input
    public final Property<String> getTag() {
        return this.tag;
    }

    @Input
    @Optional
    public final Property<Boolean> getForce() {
        return this.force;
    }

    @Override
    public void runRemoteCommand() {
        this.getLogger().quiet("Tagging image with ID '" + (String)this.getImageId().get() + "'.");
        TagImageCmd tagImageCmd = this.getDockerClient().tagImageCmd((String)this.getImageId().get(), (String)this.repository.get(), (String)this.tag.get());
        if (Boolean.TRUE.equals(this.force.getOrNull())) {
            tagImageCmd.withForce((Boolean)this.force.get());
        }
        tagImageCmd.exec();
    }
}

