/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.tasks.image;

import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.api.command.SaveImagesCmd;
import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.api.exception.DockerException;
import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.core.command.AbstrDockerCmd;
import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.core.command.SaveImagesCmdImpl;
import com.bmuschko.gradle.docker.tasks.AbstractDockerRemoteApiTask;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;

public class DockerSaveImage
extends AbstractDockerRemoteApiTask {
    private final SetProperty<String> images = this.getProject().getObjects().setProperty(String.class);
    private final Property<Boolean> useCompression = this.getProject().getObjects().property(Boolean.class);
    private final RegularFileProperty destFile = this.getProject().getObjects().fileProperty();
    private final RegularFileProperty imageIdsFile = this.getProject().getObjects().fileProperty();
    private final Spec<Task> onlyIfSpec = new Spec<Task>(){

        public boolean isSatisfiedBy(Task element) {
            return DockerSaveImage.this.getImages().getOrNull() != null;
        }
    };
    private final Spec<Task> upToDateWhenSpec = new Spec<Task>(){

        public boolean isSatisfiedBy(Task element) {
            File file = ((RegularFile)DockerSaveImage.this.getImageIdsFile().get()).getAsFile();
            if (file.exists()) {
                Properties savedImageIds = new Properties();
                try (InputStream is = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                    savedImageIds.load(is);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                Set<String> savedImages = savedImageIds.stringPropertyNames();
                Set configuredImages = (Set)DockerSaveImage.this.getImages().getOrElse(new HashSet());
                if (!savedImages.equals(configuredImages)) {
                    return false;
                }
                try {
                    for (String savedImage : savedImages) {
                        String savedId = savedImageIds.getProperty(savedImage);
                        if (savedId.equals(DockerSaveImage.this.getImageIds(savedImage))) continue;
                        return false;
                    }
                    return true;
                }
                catch (DockerException e) {
                    return false;
                }
            }
            return false;
        }
    };

    @Input
    public final SetProperty<String> getImages() {
        return this.images;
    }

    @Input
    @Optional
    public final Property<Boolean> getUseCompression() {
        return this.useCompression;
    }

    @OutputFile
    public final RegularFileProperty getDestFile() {
        return this.destFile;
    }

    @OutputFile
    public final RegularFileProperty getImageIdsFile() {
        return this.imageIdsFile;
    }

    public DockerSaveImage() {
        this.useCompression.convention((Object)false);
        String safeTaskPath = this.getPath().replaceFirst("^:", "").replaceAll(":", "_");
        this.imageIdsFile.convention(this.getProject().getLayout().getBuildDirectory().file(".docker/" + safeTaskPath + "-imageIds.properties"));
        this.onlyIf(this.onlyIfSpec);
        this.getOutputs().upToDateWhen(this.upToDateWhenSpec);
    }

    private SaveImagesCmd.Exec getExecution() {
        try {
            Field execution = AbstrDockerCmd.class.getDeclaredField("execution");
            execution.setAccessible(true);
            return (SaveImagesCmd.Exec)execution.get(this.getDockerClient().saveImagesCmd());
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void runRemoteCommand() {
        final Set images = (Set)this.getImages().getOrElse(new HashSet());
        SaveImagesCmdImpl saveImagesCmd = new SaveImagesCmdImpl(this.getExecution()){

            @Override
            public List<SaveImagesCmd.TaggedImage> getImages() {
                return images.stream().map(it -> () -> it).collect(Collectors.toList());
            }
        };
        try (InputStream image = saveImagesCmd.exec();
             OutputStream fs = Files.newOutputStream(((RegularFile)this.destFile.get()).getAsFile().toPath(), new OpenOption[0]);
             OutputStream os = (Boolean)this.useCompression.get() != false ? new GZIPOutputStream(fs) : fs;){
            image.transferTo(os);
        }
        catch (IOException e) {
            throw new GradleException("Can't save image.", (Throwable)e);
        }
        Properties imageIds = new Properties();
        for (String configuredImage : images) {
            imageIds.put(configuredImage, this.getImageIds(configuredImage));
        }
        ((RegularFile)this.imageIdsFile.get()).getAsFile().getParentFile().mkdirs();
        try (OutputStream os = Files.newOutputStream(((RegularFile)this.imageIdsFile.get()).getAsFile().toPath(), new OpenOption[0]);){
            imageIds.store(os, null);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private String getImageIds(String image) {
        if (image.contains(":")) {
            return this.getImageIdForConcreteImage(image);
        }
        return this.getImageIdsForBaseImage(image);
    }

    private String getImageIdForConcreteImage(String image) {
        return this.getDockerClient().inspectImageCmd(image).exec().getId();
    }

    private String getImageIdsForBaseImage(String image) {
        return ((List)this.getDockerClient().listImagesCmd().exec()).stream().flatMap(listedImage -> Arrays.stream(listedImage.getRepoTags()).map(it -> Map.entry(it, listedImage.getId()))).filter(i -> ((String)i.getKey()).startsWith(image)).sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).collect(Collectors.joining(","));
    }
}

