/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.tasks.image;

import com.bmuschko.gradle.docker.DockerRegistryCredentials;
import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.api.command.PullImageCmd;
import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.api.command.PullImageResultCallback;
import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.api.model.AuthConfig;
import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.api.model.PullResponseItem;
import com.bmuschko.gradle.docker.tasks.AbstractDockerRemoteApiTask;
import com.bmuschko.gradle.docker.tasks.RegistryCredentialsAware;
import org.gradle.api.Action;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;

public class DockerPullImage
extends AbstractDockerRemoteApiTask
implements RegistryCredentialsAware {
    private final Property<String> image = this.getProject().getObjects().property(String.class);
    private final Property<String> platform = this.getProject().getObjects().property(String.class);
    private final DockerRegistryCredentials registryCredentials = (DockerRegistryCredentials)this.getProject().getObjects().newInstance(DockerRegistryCredentials.class, new Object[]{this.getProject().getObjects()});

    @Input
    public final Property<String> getImage() {
        return this.image;
    }

    @Input
    @Optional
    public final Property<String> getPlatform() {
        return this.platform;
    }

    @Override
    public final DockerRegistryCredentials getRegistryCredentials() {
        return this.registryCredentials;
    }

    @Override
    public void runRemoteCommand() throws InterruptedException {
        AuthConfig authConfig = this.getRegistryAuthLocator().lookupAuthConfig((String)this.image.get(), this.registryCredentials);
        this.getLogger().quiet("Pulling image '" + (String)this.getImage().get() + "' from " + this.getRegistryAuthLocator().getRegistry((String)this.getImage().get()) + ".");
        PullImageCmd pullImageCmd = this.getDockerClient().pullImageCmd((String)this.image.get());
        if (this.platform.getOrNull() != null) {
            pullImageCmd.withPlatform((String)this.platform.get());
        }
        pullImageCmd.withAuthConfig(authConfig);
        PullImageResultCallback callback = this.createCallback(this.getNextHandler());
        pullImageCmd.exec(callback).awaitCompletion();
    }

    @Override
    public void registryCredentials(Action<? super DockerRegistryCredentials> action) {
        action.execute((Object)this.registryCredentials);
    }

    private PullImageResultCallback createCallback(final Action nextHandler) {
        return new PullImageResultCallback(){

            @Override
            public void onNext(PullResponseItem item) {
                if (nextHandler != null) {
                    try {
                        nextHandler.execute((Object)item);
                    }
                    catch (Exception e) {
                        DockerPullImage.this.getLogger().error("Failed to handle pull response", (Throwable)e);
                        return;
                    }
                }
                super.onNext(item);
            }
        };
    }
}

