/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.tasks.image;

import com.bmuschko.gradle.docker.internal.RegularFileToStringTransformer;
import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.api.command.CommitCmd;
import com.bmuschko.gradle.docker.tasks.container.DockerExistingContainer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.gradle.api.Transformer;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;

public class DockerCommitImage
extends DockerExistingContainer {
    private final Property<String> repository = this.getProject().getObjects().property(String.class);
    private final Property<String> tag = this.getProject().getObjects().property(String.class);
    private final Property<String> message = this.getProject().getObjects().property(String.class);
    private final Property<String> author = this.getProject().getObjects().property(String.class);
    private final Property<Boolean> pause = this.getProject().getObjects().property(Boolean.class);
    private final Property<Boolean> attachStderr = this.getProject().getObjects().property(Boolean.class);
    private final Property<Boolean> attachStdin = this.getProject().getObjects().property(Boolean.class);
    private final RegularFileProperty imageIdFile = this.getProject().getObjects().fileProperty();
    private final Property<String> imageId = this.getProject().getObjects().property(String.class);

    @Input
    public final Property<String> getRepository() {
        return this.repository;
    }

    @Input
    public final Property<String> getTag() {
        return this.tag;
    }

    @Input
    @Optional
    public final Property<String> getMessage() {
        return this.message;
    }

    @Input
    @Optional
    public final Property<String> getAuthor() {
        return this.author;
    }

    @Input
    @Optional
    public final Property<Boolean> getPause() {
        return this.pause;
    }

    @Input
    @Optional
    public final Property<Boolean> getAttachStderr() {
        return this.attachStderr;
    }

    @Input
    @Optional
    public final Property<Boolean> getAttachStdin() {
        return this.attachStdin;
    }

    @OutputFile
    public final RegularFileProperty getImageIdFile() {
        return this.imageIdFile;
    }

    @Internal
    public final Property<String> getImageId() {
        return this.imageId;
    }

    public DockerCommitImage() {
        this.imageId.convention(this.imageIdFile.map((Transformer)new RegularFileToStringTransformer()));
        String safeTaskPath = this.getPath().replaceFirst("^:", "").replaceAll(":", "_");
        this.imageIdFile.convention(this.getProject().getLayout().getBuildDirectory().file(".docker/" + safeTaskPath + "-imageId.txt"));
    }

    @Override
    public void runRemoteCommand() throws IOException {
        this.getLogger().quiet("Committing image '" + (String)this.getRepository().get() + ":" + (String)this.getTag().get() + "' for container '" + (String)this.getContainerId().get() + "'.");
        CommitCmd commitCmd = this.getDockerClient().commitCmd((String)this.getContainerId().get());
        commitCmd.withRepository((String)this.repository.get());
        commitCmd.withTag((String)this.tag.get());
        if (this.message.getOrNull() != null) {
            commitCmd.withMessage((String)this.message.get());
        }
        if (this.author.getOrNull() != null) {
            commitCmd.withAuthor((String)this.author.get());
        }
        if (Boolean.TRUE.equals(this.pause.getOrNull())) {
            commitCmd.withPause((Boolean)this.pause.get());
        }
        if (Boolean.TRUE.equals(this.attachStderr.getOrNull())) {
            commitCmd.withAttachStderr((Boolean)this.attachStderr.get());
        }
        if (Boolean.TRUE.equals(this.attachStdin.getOrNull())) {
            commitCmd.withAttachStdin((Boolean)this.attachStdin.get());
        }
        String createdImageId = commitCmd.exec();
        Files.write(((RegularFile)this.imageIdFile.get()).getAsFile().toPath(), createdImageId.getBytes(), new OpenOption[0]);
        this.getLogger().quiet("Created image with ID '" + createdImageId + "'.");
        if (this.getNextHandler() != null) {
            this.getNextHandler().execute((Object)createdImageId);
        }
    }
}

