/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.tasks.container;

import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.api.DockerClient;
import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.api.async.ResultCallback;
import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.api.command.LogContainerCmd;
import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.api.model.Frame;
import com.bmuschko.gradle.docker.tasks.container.DockerExistingContainer;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Date;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;

public class DockerLogsContainer
extends DockerExistingContainer {
    private final Property<Boolean> follow = this.getProject().getObjects().property(Boolean.class);
    private final Property<Boolean> tailAll = this.getProject().getObjects().property(Boolean.class);
    private final Property<Integer> tailCount = this.getProject().getObjects().property(Integer.class);
    private final Property<Boolean> stdOut = this.getProject().getObjects().property(Boolean.class);
    private final Property<Boolean> stdErr = this.getProject().getObjects().property(Boolean.class);
    private final Property<Boolean> showTimestamps = this.getProject().getObjects().property(Boolean.class);
    private final Property<Date> since = this.getProject().getObjects().property(Date.class);
    private Writer sink;

    @Input
    @Optional
    public final Property<Boolean> getFollow() {
        return this.follow;
    }

    @Input
    @Optional
    public final Property<Boolean> getTailAll() {
        return this.tailAll;
    }

    @Input
    @Optional
    public final Property<Integer> getTailCount() {
        return this.tailCount;
    }

    @Input
    @Optional
    public final Property<Boolean> getStdOut() {
        return this.stdOut;
    }

    @Input
    @Optional
    public final Property<Boolean> getStdErr() {
        return this.stdErr;
    }

    @Input
    @Optional
    public final Property<Boolean> getShowTimestamps() {
        return this.showTimestamps;
    }

    @Input
    @Optional
    public final Property<Date> getSince() {
        return this.since;
    }

    @Input
    @Optional
    public Writer getSink() {
        return this.sink;
    }

    public Writer setSink(Writer sink) {
        if (sink != null) {
            this.notCompatibleWithConfigurationCache("Setting sink is not compatible with configuration cache");
            this.sink = sink;
            return this.sink;
        }
        this.isCompatibleWithConfigurationCache();
        this.sink = null;
        return null;
    }

    @Internal
    protected Date getInternalSince() {
        return (Date)this.since.getOrNull();
    }

    public DockerLogsContainer() {
        this.stdOut.convention((Object)true);
        this.stdErr.convention((Object)true);
    }

    @Override
    public void runRemoteCommand() throws InterruptedException {
        this.getLogger().quiet("Logs for container with ID '" + (String)this.getContainerId().get() + "'.");
        this.logAndProcessResponse(this.getDockerClient());
    }

    public void logAndProcessResponse(DockerClient dockerClient) throws InterruptedException {
        LogContainerCmd logCommand = dockerClient.logContainerCmd((String)this.getContainerId().get());
        this.setContainerCommandConfig(logCommand);
        logCommand.exec(this.createCallback(this.getNextHandler())).awaitCompletion();
    }

    private ResultCallback.Adapter<Frame> createCallback(final Action nextHandler) {
        if (this.sink != null && nextHandler != null) {
            throw new GradleException("Define either sink or onNext");
        }
        if (this.sink != null) {
            return new ResultCallback.Adapter<Frame>(){

                @Override
                public void onNext(Frame frame) {
                    switch (frame.getStreamType()) {
                        case STDOUT: 
                        case RAW: 
                        case STDERR: {
                            try {
                                DockerLogsContainer.this.getSink().append(new String(frame.getPayload()));
                                DockerLogsContainer.this.getSink().flush();
                                break;
                            }
                            catch (IOException e) {
                                throw new UncheckedIOException(e);
                            }
                        }
                    }
                    super.onNext(frame);
                }
            };
        }
        if (nextHandler != null) {
            return new ResultCallback.Adapter<Frame>(){

                @Override
                public void onNext(Frame frame) {
                    nextHandler.execute((Object)frame);
                    super.onNext(frame);
                }
            };
        }
        return new ResultCallback.Adapter<Frame>(){

            @Override
            public void onNext(Frame frame) {
                switch (frame.getStreamType()) {
                    case STDOUT: 
                    case RAW: {
                        DockerLogsContainer.this.getLogger().quiet(new String(frame.getPayload()).replaceFirst("/\\s+$/", ""));
                        break;
                    }
                    case STDERR: {
                        DockerLogsContainer.this.getLogger().error(new String(frame.getPayload()).replaceFirst("/\\s+$/", ""));
                    }
                }
                super.onNext(frame);
            }
        };
    }

    private void setContainerCommandConfig(LogContainerCmd logsCommand) {
        if (this.follow.getOrNull() != null) {
            logsCommand.withFollowStream((Boolean)this.follow.get());
        }
        if (this.showTimestamps.getOrNull() != null) {
            logsCommand.withTimestamps((Boolean)this.showTimestamps.get());
        }
        logsCommand.withStdOut((Boolean)this.stdOut.get()).withStdErr((Boolean)this.stdErr.get());
        if (Boolean.TRUE.equals(this.tailAll.getOrNull()) && this.tailCount.getOrNull() != null) {
            throw new InvalidUserDataException("Conflicting parameters: only one of tailAll and tailCount can be specified");
        }
        if (Boolean.TRUE.equals(this.tailAll.getOrNull())) {
            logsCommand.withTailAll();
        } else if (this.tailCount.getOrNull() != null) {
            logsCommand.withTail((Integer)this.tailCount.get());
        }
        Date since = this.getInternalSince();
        if (since != null) {
            logsCommand.withSince((int)(since.getTime() / 1000L));
        }
    }
}

