/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.tasks.container;

import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.api.command.InspectExecResponse;
import com.bmuschko.gradle.docker.tasks.AbstractDockerRemoteApiTask;
import java.util.concurrent.Callable;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;

public class DockerInspectExecContainer
extends AbstractDockerRemoteApiTask {
    private final Property<String> execId = this.getProject().getObjects().property(String.class);

    @Input
    public final Property<String> getExecId() {
        return this.execId;
    }

    public void targetExecId(String execId) {
        this.execId.set((Object)execId);
    }

    public void targetExecId(Callable<String> execId) {
        this.targetExecId((Provider<String>)this.getProject().provider(execId));
    }

    public void targetExecId(Provider<String> execId) {
        this.execId.set(execId);
    }

    @Override
    public void runRemoteCommand() {
        this.getLogger().quiet("Inspecting exec with ID '" + (String)this.getExecId().get() + "'.");
        InspectExecResponse result = this.getDockerClient().inspectExecCmd((String)this.execId.get()).exec();
        if (this.getNextHandler() != null) {
            this.getNextHandler().execute((Object)result);
        } else {
            this.getLogger().quiet("Exec ID: {}", new Object[]{result.getId()});
            this.getLogger().quiet("Container ID: {}", new Object[]{result.getContainerID()});
            this.getLogger().quiet("Is running: {}", new Object[]{result.isRunning()});
            this.getLogger().quiet("Exit code: {}", new Object[]{result.getExitCode()});
        }
    }
}

