/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.tasks.container;

import com.bmuschko.gradle.docker.domain.ExecProbe;
import com.bmuschko.gradle.docker.internal.IOUtils;
import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.api.DockerClient;
import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.api.async.ResultCallback;
import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.api.command.ExecCreateCmd;
import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.api.command.InspectExecResponse;
import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.api.model.Frame;
import com.bmuschko.gradle.docker.tasks.container.DockerExistingContainer;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.internal.logging.progress.ProgressLogger;

public class DockerExecContainer
extends DockerExistingContainer {
    private final ListProperty<String[]> commands = this.getProject().getObjects().listProperty(String[].class);
    private final Property<Boolean> attachStdout = this.getProject().getObjects().property(Boolean.class);
    private final Property<Boolean> attachStderr = this.getProject().getObjects().property(Boolean.class);
    private final Property<String> user = this.getProject().getObjects().property(String.class);
    private final Property<String> workingDir = this.getProject().getObjects().property(String.class);
    private final ListProperty<Integer> successOnExitCodes = this.getProject().getObjects().listProperty(Integer.class);
    private ExecProbe execProbe;
    private final ListProperty<String> execIds = this.getProject().getObjects().listProperty(String.class);

    @Input
    @Optional
    public final ListProperty<String[]> getCommands() {
        return this.commands;
    }

    @Input
    @Optional
    public final Property<Boolean> getAttachStdout() {
        return this.attachStdout;
    }

    @Input
    @Optional
    public final Property<Boolean> getAttachStderr() {
        return this.attachStderr;
    }

    @Input
    @Optional
    public final Property<String> getUser() {
        return this.user;
    }

    @Input
    @Optional
    public final Property<String> getWorkingDir() {
        return this.workingDir;
    }

    @Input
    @Optional
    public final ListProperty<Integer> getSuccessOnExitCodes() {
        return this.successOnExitCodes;
    }

    @Nested
    @Optional
    public ExecProbe getExecProbe() {
        return this.execProbe;
    }

    public void setExecProbe(ExecProbe execProbe) {
        this.execProbe = execProbe;
    }

    @Internal
    public final ListProperty<String> getExecIds() {
        return this.execIds;
    }

    public DockerExecContainer() {
        this.attachStdout.convention((Object)true);
        this.attachStderr.convention((Object)true);
    }

    @Override
    public void runRemoteCommand() throws InterruptedException {
        this.getLogger().quiet("Executing on container with ID '" + (String)this.getContainerId().get() + "'.");
        this.doRunRemoteCommand(this.getDockerClient());
    }

    protected void doRunRemoteCommand(DockerClient dockerClient) throws InterruptedException {
        ResultCallback.Adapter<Frame> execCallback = this.createCallback(this.getNextHandler());
        List localCommands = (List)this.commands.get();
        for (int i = 0; i < ((List)this.commands.get()).size(); ++i) {
            Object[] singleCommand = (String[])localCommands.get(i);
            ExecCreateCmd execCmd = dockerClient.execCreateCmd((String)this.getContainerId().get());
            this.setContainerCommandConfig(execCmd, (String[])singleCommand);
            String localExecId = ((ExecCreateCmdResponse)execCmd.exec()).getId();
            dockerClient.execStartCmd(localExecId).withDetach(false).exec(execCallback).awaitCompletion();
            ProgressLogger progressLogger = IOUtils.getProgressLogger(this.getServices(), DockerExecContainer.class);
            progressLogger.started();
            ExecProbe localProbe = this.execProbe != null ? this.execProbe : new ExecProbe(60000L, 2000L);
            int pollTimes = 0;
            boolean isRunning = true;
            InspectExecResponse lastExecResponse = null;
            for (long localPollTime = localProbe.getPollTime(); isRunning && localPollTime > 0L; localPollTime -= localProbe.getPollInterval()) {
                ++pollTimes;
                lastExecResponse = dockerClient.inspectExecCmd(localExecId).exec();
                isRunning = lastExecResponse.isRunning();
                if (!isRunning) break;
                long totalMillis = (long)pollTimes * localProbe.getPollInterval();
                long totalMinutes = TimeUnit.MILLISECONDS.toMinutes(totalMillis);
                progressLogger.progress("Executing for " + totalMinutes + "m...");
                Thread.sleep(localProbe.getPollInterval());
                continue;
            }
            progressLogger.completed();
            if (isRunning) {
                throw new GradleException("Exec '" + Arrays.toString(singleCommand) + "' did not finish in a timely fashion: " + localProbe);
            }
            if (this.successOnExitCodes.getOrNull() != null && !((List)this.successOnExitCodes.get()).isEmpty()) {
                int exitCode;
                int n = exitCode = lastExecResponse.getExitCode() != null ? lastExecResponse.getExitCode() : 0;
                if (!((List)this.successOnExitCodes.get()).contains(exitCode)) {
                    throw new GradleException(exitCode + " is not a successful exit code. Valid values are " + this.getSuccessOnExitCodes().get() + ", response=" + lastExecResponse);
                }
            }
            this.execIds.add((Object)localExecId);
        }
    }

    public void withCommand(List<String> commandsToExecute) {
        this.withCommand((String[])commandsToExecute.toArray(String[]::new));
    }

    public void withCommand(String[] commandsToExecute) {
        if (commandsToExecute != null) {
            this.commands.add((Object)commandsToExecute);
        }
    }

    private void setContainerCommandConfig(ExecCreateCmd containerCommand, String[] commandToExecute) {
        if (commandToExecute != null) {
            containerCommand.withCmd(commandToExecute);
        }
        if (Boolean.TRUE.equals(this.attachStderr.getOrNull())) {
            containerCommand.withAttachStderr((Boolean)this.attachStderr.get());
        }
        if (Boolean.TRUE.equals(this.attachStdout.getOrNull())) {
            containerCommand.withAttachStdout((Boolean)this.attachStdout.get());
        }
        if (this.user.getOrNull() != null) {
            containerCommand.withUser((String)this.user.get());
        }
        if (this.workingDir.getOrNull() != null) {
            containerCommand.withWorkingDir((String)this.workingDir.get());
        }
    }

    public ExecProbe execProbe(long pollTime, long pollInterval) {
        this.execProbe = new ExecProbe(pollTime, pollInterval);
        return this.execProbe;
    }

    private ResultCallback.Adapter<Frame> createCallback(final Action nextHandler) {
        if (nextHandler != null) {
            return new ResultCallback.Adapter<Frame>(){

                @Override
                public void onNext(Frame frame) {
                    try {
                        nextHandler.execute((Object)frame);
                    }
                    catch (Exception e) {
                        DockerExecContainer.this.getLogger().error("Failed to handle frame", (Throwable)e);
                        return;
                    }
                    super.onNext(frame);
                }
            };
        }
        return new ResultCallback.Adapter<Frame>(){

            @Override
            public void onNext(Frame frame) {
                if (frame != null) {
                    switch (frame.getStreamType()) {
                        case STDOUT: 
                        case RAW: {
                            try {
                                System.out.write(frame.getPayload());
                            }
                            catch (IOException e) {
                                throw new UncheckedIOException(e);
                            }
                            System.out.flush();
                            break;
                        }
                        case STDERR: {
                            try {
                                System.err.write(frame.getPayload());
                            }
                            catch (IOException e) {
                                throw new UncheckedIOException(e);
                            }
                            System.err.flush();
                            break;
                        }
                        default: {
                            DockerExecContainer.this.getLogger().error("unknown stream type:" + frame.getStreamType());
                        }
                    }
                }
            }
        };
    }
}

