/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.shaded.com.github.dockerjava.core.util;

import com.bmuschko.gradle.docker.shaded.com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FiltersBuilder {
    private static final Pattern UNTIL_TIMESTAMP_PATTERN = Pattern.compile("^\\d{1,10}$");
    private static final Pattern UNTIL_DATETIME_PATTERN = Pattern.compile("^([0-9]+)-(0[1-9]|1[012])-(0[1-9]|[12][0-9]|3[01])([Tt]([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9]|60)(\\.[0-9]+)?)?(([Zz])|([\\+|\\-]([01][0-9]|2[0-3]):[0-5][0-9]))?$");
    private static final Pattern UNTIL_GO_PATTERN = Pattern.compile("^([1-9][0-9]*h)?([1-9][0-9]*m)?([1-9][0-9]*s)?$");
    private Map<String, List<String>> filters = new HashMap<String, List<String>>();

    public FiltersBuilder withFilter(String key, String ... value) {
        this.filters.put(key, Arrays.asList(value));
        return this;
    }

    public FiltersBuilder withFilter(String key, Collection<String> value) {
        this.filters.put(key, (List<String>)(value instanceof List ? (List<Object>)value : new ArrayList<String>(value)));
        return this;
    }

    public List<String> getFilter(String key) {
        return this.filters.get(key);
    }

    public FiltersBuilder withImages(String ... image) {
        this.withFilter("image", image);
        return this;
    }

    public List<String> getImage() {
        return this.getFilter("image");
    }

    public FiltersBuilder withContainers(String ... container) {
        this.withFilter("container", container);
        return this;
    }

    public List<String> getContainer() {
        return this.getFilter("container");
    }

    public FiltersBuilder withEventTypes(String ... eventTypes) {
        this.withFilter("type", Stream.of(eventTypes).collect(Collectors.toList()));
        return this;
    }

    public FiltersBuilder withLabels(String ... labels) {
        this.withFilter("label", labels);
        return this;
    }

    public FiltersBuilder withLabels(Map<String, String> labels) {
        this.withFilter("label", FiltersBuilder.labelsMapToList(labels).toArray(new String[labels.size()]));
        return this;
    }

    public FiltersBuilder withUntil(String until) throws NumberFormatException {
        if (!this.isValidUntil(until)) {
            throw new NumberFormatException("Not valid format of 'until': " + until);
        }
        return this.withFilter("until", until);
    }

    private static List<String> labelsMapToList(Map<String, String> labels) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, String> entry : labels.entrySet()) {
            String rest = entry.getValue() != null & !entry.getValue().isEmpty() ? "=" + entry.getValue() : "";
            String label = entry.getKey() + rest;
            result.add(label);
        }
        return result;
    }

    private boolean isValidUntil(String until) {
        if (UNTIL_DATETIME_PATTERN.matcher(until).matches()) {
            return true;
        }
        if (!Strings.isNullOrEmpty(until) && UNTIL_GO_PATTERN.matcher(until).matches()) {
            return true;
        }
        return UNTIL_TIMESTAMP_PATTERN.matcher(until).matches();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FiltersBuilder filters1 = (FiltersBuilder)o;
        return this.filters.equals(filters1.filters);
    }

    public int hashCode() {
        return this.filters.hashCode();
    }

    public Map<String, List<String>> build() {
        return this.filters;
    }
}

