/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.shaded.com.github.dockerjava.core.exec;

import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.api.command.SaveImagesCmd;
import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.core.DockerClientConfig;
import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.core.MediaType;
import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.core.WebTarget;
import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.core.exec.AbstrSyncDockerCmdExec;
import com.bmuschko.gradle.docker.shaded.com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveImagesCmdExec
extends AbstrSyncDockerCmdExec<SaveImagesCmd, InputStream>
implements SaveImagesCmd.Exec {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaveImagesCmdExec.class);

    public SaveImagesCmdExec(WebTarget baseResource, DockerClientConfig dockerClientConfig) {
        super(baseResource, dockerClientConfig);
    }

    @Override
    protected InputStream execute(SaveImagesCmd command) {
        List<SaveImagesCmd.TaggedImage> images = command.getImages();
        if (images.isEmpty()) {
            LOGGER.warn("No images specified for " + SaveImagesCmd.class.getName() + ".");
        }
        ImmutableSet.Builder queryParamSet = ImmutableSet.builder();
        for (SaveImagesCmd.TaggedImage image : images) {
            queryParamSet.add(image.asString());
        }
        WebTarget webResource = this.getBaseResource().path("/images/get").queryParamsSet("names", (Set<?>)((Object)queryParamSet.build()));
        LOGGER.trace("GET: {}", (Object)webResource);
        return webResource.request().accept(MediaType.APPLICATION_JSON).get();
    }
}

