/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.shaded.com.github.dockerjava.core.command;

import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.api.command.ListImagesCmd;
import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.api.model.Image;
import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.core.command.AbstrDockerCmd;
import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.core.util.FiltersBuilder;
import com.bmuschko.gradle.docker.shaded.com.google.common.base.Preconditions;
import com.bmuschko.gradle.docker.shaded.org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import com.bmuschko.gradle.docker.shaded.org.apache.commons.lang3.builder.ToStringStyle;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ListImagesCmdImpl
extends AbstrDockerCmd<ListImagesCmd, List<Image>>
implements ListImagesCmd {
    private String imageNameFilter;
    private Boolean showAll = false;
    private FiltersBuilder filters = new FiltersBuilder();

    public ListImagesCmdImpl(ListImagesCmd.Exec exec) {
        super(exec);
    }

    @Override
    public Map<String, List<String>> getFilters() {
        return this.filters.build();
    }

    @Override
    public Boolean hasShowAllEnabled() {
        return this.showAll;
    }

    @Override
    public ListImagesCmd withShowAll(Boolean showAll) {
        this.showAll = showAll;
        return this;
    }

    @Override
    public ListImagesCmd withDanglingFilter(Boolean dangling) {
        Preconditions.checkNotNull(dangling, "dangling have not been specified");
        this.withFilter("dangling", Collections.singletonList(dangling.toString()));
        return this;
    }

    @Override
    public ListImagesCmd withLabelFilter(String ... labels) {
        Preconditions.checkNotNull(labels, "labels have not been specified");
        this.filters.withLabels(labels);
        return this;
    }

    @Override
    public ListImagesCmd withLabelFilter(Map<String, String> labels) {
        Preconditions.checkNotNull(labels, "labels have not been specified");
        this.filters.withLabels(labels);
        return this;
    }

    @Override
    public ListImagesCmd withImageNameFilter(String imageNameFilter) {
        Preconditions.checkNotNull(imageNameFilter, "image name filter not specified");
        this.imageNameFilter = imageNameFilter;
        return this;
    }

    @Override
    public ListImagesCmd withReferenceFilter(String reference) {
        Preconditions.checkNotNull(reference, "reference filter not specified");
        this.withFilter("reference", Collections.singletonList(reference));
        return this;
    }

    @Override
    public ListImagesCmd withFilter(String key, Collection<String> values) {
        Preconditions.checkNotNull(key, "key not specified");
        Preconditions.checkNotNull(values, "values not specified");
        this.filters.withFilter(key, values);
        return this;
    }

    @Override
    public String getImageNameFilter() {
        return this.imageNameFilter;
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

