/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.shaded.com.github.dockerjava.core.command;

import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.api.command.ListContainersCmd;
import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.api.model.Container;
import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.core.command.AbstrDockerCmd;
import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.core.util.FiltersBuilder;
import com.bmuschko.gradle.docker.shaded.com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ListContainersCmdImpl
extends AbstrDockerCmd<ListContainersCmd, List<Container>>
implements ListContainersCmd {
    private Integer limit = -1;
    private Boolean showSize;
    private Boolean showAll = false;
    private String sinceId;
    private String beforeId;
    private FiltersBuilder filters = new FiltersBuilder();

    public ListContainersCmdImpl(ListContainersCmd.Exec exec) {
        super(exec);
    }

    @Override
    public Integer getLimit() {
        return this.limit;
    }

    @Override
    public Boolean hasShowSizeEnabled() {
        return this.showSize;
    }

    @Override
    public Boolean hasShowAllEnabled() {
        return this.showAll;
    }

    @Override
    public String getSinceId() {
        return this.sinceId;
    }

    @Override
    public String getBeforeId() {
        return this.beforeId;
    }

    @Override
    public Map<String, List<String>> getFilters() {
        return this.filters.build();
    }

    @Override
    public ListContainersCmd withShowAll(Boolean showAll) {
        this.showAll = showAll;
        return this;
    }

    @Override
    public ListContainersCmd withShowSize(Boolean showSize) {
        this.showSize = showSize;
        return this;
    }

    @Override
    public ListContainersCmd withLimit(Integer limit) {
        Preconditions.checkNotNull(limit, "limit was not specified");
        Preconditions.checkArgument(limit > 0, "limit must be greater 0");
        this.limit = limit;
        return this;
    }

    @Override
    public ListContainersCmd withSince(String since) {
        Preconditions.checkNotNull(since, "since was not specified");
        this.sinceId = since;
        return this;
    }

    @Override
    public ListContainersCmd withBefore(String before) {
        Preconditions.checkNotNull(before, "before was not specified");
        this.beforeId = before;
        return this;
    }

    @Override
    public ListContainersCmd withNameFilter(Collection<String> name) {
        return this.withFilter("name", name);
    }

    @Override
    public ListContainersCmd withIdFilter(Collection<String> id) {
        return this.withFilter("id", id);
    }

    @Override
    public ListContainersCmd withAncestorFilter(Collection<String> ancestor) {
        return this.withFilter("ancestor", ancestor);
    }

    @Override
    public ListContainersCmd withVolumeFilter(Collection<String> volume) {
        return this.withFilter("volume", volume);
    }

    @Override
    public ListContainersCmd withNetworkFilter(Collection<String> network) {
        return this.withFilter("network", network);
    }

    @Override
    public ListContainersCmd withLabelFilter(Collection<String> labels) {
        return this.withFilter("label", labels);
    }

    @Override
    public ListContainersCmd withLabelFilter(Map<String, String> labels) {
        Preconditions.checkNotNull(labels, "labels was not specified");
        this.filters.withLabels(labels);
        return this;
    }

    @Override
    public ListContainersCmd withExitedFilter(Integer exited) {
        Preconditions.checkNotNull(exited, "exited was not specified");
        this.filters.withFilter("exited", exited.toString());
        return this;
    }

    @Override
    public ListContainersCmd withFilter(String filterName, Collection<String> filterValues) {
        Preconditions.checkNotNull(filterValues, filterName + " was not specified");
        this.filters.withFilter(filterName, filterValues);
        return this;
    }

    @Override
    public ListContainersCmd withStatusFilter(Collection<String> status) {
        Preconditions.checkNotNull(status, "status was not specified");
        this.filters.withFilter("status", status);
        return this;
    }
}

