/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.shaded.com.github.dockerjava.core;

import com.bmuschko.gradle.docker.shaded.com.google.common.base.MoreObjects;
import com.bmuschko.gradle.docker.shaded.com.google.common.base.Objects;
import com.bmuschko.gradle.docker.shaded.com.google.common.base.Preconditions;
import com.bmuschko.gradle.docker.shaded.com.google.common.base.Strings;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RemoteApiVersion
implements Serializable {
    private static final long serialVersionUID = -5382212999262115459L;
    private static final Pattern VERSION_REGEX = Pattern.compile("v?(\\d+)\\.(\\d+)");
    public static final RemoteApiVersion VERSION_1_7 = RemoteApiVersion.create(1, 7);
    public static final RemoteApiVersion VERSION_1_16 = RemoteApiVersion.create(1, 16);
    public static final RemoteApiVersion VERSION_1_17 = RemoteApiVersion.create(1, 17);
    public static final RemoteApiVersion VERSION_1_18 = RemoteApiVersion.create(1, 18);
    public static final RemoteApiVersion VERSION_1_19 = RemoteApiVersion.create(1, 19);
    public static final RemoteApiVersion VERSION_1_20 = RemoteApiVersion.create(1, 20);
    public static final RemoteApiVersion VERSION_1_21 = RemoteApiVersion.create(1, 21);
    public static final RemoteApiVersion VERSION_1_22 = RemoteApiVersion.create(1, 22);
    public static final RemoteApiVersion VERSION_1_23 = RemoteApiVersion.create(1, 23);
    public static final RemoteApiVersion VERSION_1_24 = RemoteApiVersion.create(1, 24);
    public static final RemoteApiVersion VERSION_1_25 = RemoteApiVersion.create(1, 25);
    public static final RemoteApiVersion VERSION_1_26 = RemoteApiVersion.create(1, 26);
    public static final RemoteApiVersion VERSION_1_27 = RemoteApiVersion.create(1, 27);
    public static final RemoteApiVersion VERSION_1_28 = RemoteApiVersion.create(1, 28);
    public static final RemoteApiVersion VERSION_1_29 = RemoteApiVersion.create(1, 29);
    public static final RemoteApiVersion VERSION_1_30 = RemoteApiVersion.create(1, 30);
    public static final RemoteApiVersion VERSION_1_31 = RemoteApiVersion.create(1, 31);
    public static final RemoteApiVersion VERSION_1_32 = RemoteApiVersion.create(1, 32);
    public static final RemoteApiVersion VERSION_1_33 = RemoteApiVersion.create(1, 33);
    public static final RemoteApiVersion VERSION_1_34 = RemoteApiVersion.create(1, 34);
    public static final RemoteApiVersion VERSION_1_35 = RemoteApiVersion.create(1, 35);
    public static final RemoteApiVersion VERSION_1_36 = RemoteApiVersion.create(1, 36);
    public static final RemoteApiVersion VERSION_1_37 = RemoteApiVersion.create(1, 37);
    public static final RemoteApiVersion VERSION_1_38 = RemoteApiVersion.create(1, 38);
    public static final RemoteApiVersion VERSION_1_40 = RemoteApiVersion.create(1, 40);
    public static final RemoteApiVersion UNKNOWN_VERSION = new RemoteApiVersion(0, 0){

        @Override
        public boolean isGreaterOrEqual(RemoteApiVersion other) {
            return false;
        }

        @Override
        public boolean isGreater(RemoteApiVersion other) {
            return false;
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this).addValue("UNKNOWN_VERSION").toString();
        }

        @Override
        public String asWebPathPart() {
            return "";
        }
    };
    private final int major;
    private final int minor;

    private RemoteApiVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public static RemoteApiVersion create(int major, int minor) {
        Preconditions.checkArgument(major > 0, "Major version must be bigger than 0 but is " + major);
        Preconditions.checkArgument(minor > 0, "Minor version must be bigger than 0 but is " + minor);
        return new RemoteApiVersion(major, minor);
    }

    public static RemoteApiVersion unknown() {
        return UNKNOWN_VERSION;
    }

    public static RemoteApiVersion parseConfig(String version) {
        Preconditions.checkArgument(version != null, "Version must not be null");
        Matcher matcher = VERSION_REGEX.matcher(version);
        if (matcher.matches()) {
            return RemoteApiVersion.create(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)));
        }
        throw new IllegalArgumentException(version + " can not be parsed");
    }

    public static RemoteApiVersion parseConfigWithDefault(String version) {
        if (Strings.isNullOrEmpty(version)) {
            return UNKNOWN_VERSION;
        }
        try {
            return RemoteApiVersion.parseConfig(version);
        }
        catch (IllegalArgumentException e) {
            return UNKNOWN_VERSION;
        }
    }

    public boolean isGreaterOrEqual(RemoteApiVersion other) {
        return this.major >= other.major && this.minor >= other.minor;
    }

    public boolean isGreater(RemoteApiVersion other) {
        return this.major > other.major || this.major == other.major && this.minor > other.minor;
    }

    public String getVersion() {
        return this.major + "." + this.minor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteApiVersion that = (RemoteApiVersion)o;
        return Objects.equal(this.major, that.major) && Objects.equal(this.minor, that.minor);
    }

    public int hashCode() {
        return Objects.hashCode(this.major, this.minor);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("major", this.major).add("minor", this.minor).toString();
    }

    public String asWebPathPart() {
        return "v" + this.major + "." + this.minor;
    }
}

