/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.shaded.com.github.dockerjava.core;

import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.api.async.ResultCallback;
import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.api.model.Frame;
import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.api.model.StreamType;
import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.transport.DockerHttpClient;
import java.io.InputStream;
import java.util.Arrays;
import java.util.function.Consumer;

class FramedInputStreamConsumer
implements Consumer<DockerHttpClient.Response> {
    private final ResultCallback<Frame> resultCallback;

    FramedInputStreamConsumer(ResultCallback<Frame> resultCallback) {
        this.resultCallback = resultCallback;
    }

    @Override
    public void accept(DockerHttpClient.Response response) {
        try {
            InputStream body = response.getBody();
            byte[] buffer = new byte[1024];
            while (true) {
                int readBytes;
                int streamTypeByte;
                if ((streamTypeByte = body.read()) < 0) {
                    return;
                }
                StreamType streamType = FramedInputStreamConsumer.streamType(streamTypeByte);
                if (streamType == StreamType.RAW) {
                    int readBytes2;
                    this.resultCallback.onNext(new Frame(StreamType.RAW, new byte[]{(byte)streamTypeByte}));
                    while ((readBytes2 = body.read(buffer)) >= 0) {
                        if (readBytes2 == buffer.length) {
                            this.resultCallback.onNext(new Frame(StreamType.RAW, buffer));
                            continue;
                        }
                        this.resultCallback.onNext(new Frame(StreamType.RAW, Arrays.copyOf(buffer, readBytes2)));
                    }
                    return;
                }
                for (int i = 0; i < 3; ++i) {
                    if (body.read() >= 0) continue;
                    return;
                }
                int bytesToRead = 0;
                for (int i = 0; i < 4; ++i) {
                    int readByte = body.read();
                    if (readByte < 0) {
                        return;
                    }
                    bytesToRead |= (readByte & 0xFF) << 8 * (3 - i);
                }
                do {
                    if ((readBytes = body.read(buffer, 0, Math.min(buffer.length, bytesToRead))) < 0) {
                        return;
                    }
                    if (readBytes == buffer.length) {
                        this.resultCallback.onNext(new Frame(streamType, buffer));
                        continue;
                    }
                    this.resultCallback.onNext(new Frame(streamType, Arrays.copyOf(buffer, readBytes)));
                } while ((bytesToRead -= readBytes) > 0);
            }
        }
        catch (Exception e) {
            this.resultCallback.onError(e);
            return;
        }
    }

    private static StreamType streamType(int streamType) {
        switch (streamType) {
            case 0: {
                return StreamType.STDIN;
            }
            case 1: {
                return StreamType.STDOUT;
            }
            case 2: {
                return StreamType.STDERR;
            }
        }
        return StreamType.RAW;
    }
}

