/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.shaded.com.github.dockerjava.api.model;

import com.bmuschko.gradle.docker.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.api.model.BindOptions;
import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.api.model.DockerObject;
import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.api.model.MountType;
import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.api.model.TmpfsOptions;
import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.api.model.VolumeOptions;
import com.bmuschko.gradle.docker.shaded.javax.annotation.CheckForNull;
import java.io.Serializable;

public class Mount
extends DockerObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="Type")
    private MountType type;
    @JsonProperty(value="Source")
    private String source;
    @JsonProperty(value="Target")
    private String target;
    @JsonProperty(value="ReadOnly")
    private Boolean readOnly;
    @JsonProperty(value="BindOptions")
    private BindOptions bindOptions;
    @JsonProperty(value="VolumeOptions")
    private VolumeOptions volumeOptions;
    @JsonProperty(value="TmpfsOptions")
    private TmpfsOptions tmpfsOptions;

    @CheckForNull
    public MountType getType() {
        return this.type;
    }

    public Mount withType(MountType type) {
        this.type = type;
        return this;
    }

    @CheckForNull
    public String getSource() {
        return this.source;
    }

    public Mount withSource(String source) {
        this.source = source;
        return this;
    }

    @CheckForNull
    public String getTarget() {
        return this.target;
    }

    public Mount withTarget(String target) {
        this.target = target;
        return this;
    }

    @CheckForNull
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public Mount withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @CheckForNull
    public BindOptions getBindOptions() {
        return this.bindOptions;
    }

    public Mount withBindOptions(BindOptions bindOptions) {
        this.bindOptions = bindOptions;
        if (bindOptions != null) {
            this.type = MountType.BIND;
        }
        return this;
    }

    @CheckForNull
    public VolumeOptions getVolumeOptions() {
        return this.volumeOptions;
    }

    public Mount withVolumeOptions(VolumeOptions volumeOptions) {
        this.volumeOptions = volumeOptions;
        if (volumeOptions != null) {
            this.type = MountType.VOLUME;
        }
        return this;
    }

    @CheckForNull
    public TmpfsOptions getTmpfsOptions() {
        return this.tmpfsOptions;
    }

    public Mount withTmpfsOptions(TmpfsOptions tmpfsOptions) {
        this.tmpfsOptions = tmpfsOptions;
        if (tmpfsOptions != null) {
            this.type = MountType.TMPFS;
        }
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Mount)) {
            return false;
        }
        Mount other = (Mount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$readOnly = this.getReadOnly();
        Boolean other$readOnly = other.getReadOnly();
        if (this$readOnly == null ? other$readOnly != null : !((Object)this$readOnly).equals(other$readOnly)) {
            return false;
        }
        MountType this$type = this.getType();
        MountType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$target = this.getTarget();
        String other$target = other.getTarget();
        if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
            return false;
        }
        BindOptions this$bindOptions = this.getBindOptions();
        BindOptions other$bindOptions = other.getBindOptions();
        if (this$bindOptions == null ? other$bindOptions != null : !((Object)this$bindOptions).equals(other$bindOptions)) {
            return false;
        }
        VolumeOptions this$volumeOptions = this.getVolumeOptions();
        VolumeOptions other$volumeOptions = other.getVolumeOptions();
        if (this$volumeOptions == null ? other$volumeOptions != null : !((Object)this$volumeOptions).equals(other$volumeOptions)) {
            return false;
        }
        TmpfsOptions this$tmpfsOptions = this.getTmpfsOptions();
        TmpfsOptions other$tmpfsOptions = other.getTmpfsOptions();
        return !(this$tmpfsOptions == null ? other$tmpfsOptions != null : !((Object)this$tmpfsOptions).equals(other$tmpfsOptions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Mount;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $readOnly = this.getReadOnly();
        result = result * 59 + ($readOnly == null ? 43 : ((Object)$readOnly).hashCode());
        MountType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        BindOptions $bindOptions = this.getBindOptions();
        result = result * 59 + ($bindOptions == null ? 43 : ((Object)$bindOptions).hashCode());
        VolumeOptions $volumeOptions = this.getVolumeOptions();
        result = result * 59 + ($volumeOptions == null ? 43 : ((Object)$volumeOptions).hashCode());
        TmpfsOptions $tmpfsOptions = this.getTmpfsOptions();
        result = result * 59 + ($tmpfsOptions == null ? 43 : ((Object)$tmpfsOptions).hashCode());
        return result;
    }

    public String toString() {
        return "Mount(type=" + (Object)((Object)this.getType()) + ", source=" + this.getSource() + ", target=" + this.getTarget() + ", readOnly=" + this.getReadOnly() + ", bindOptions=" + this.getBindOptions() + ", volumeOptions=" + this.getVolumeOptions() + ", tmpfsOptions=" + this.getTmpfsOptions() + ")";
    }
}

