/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.shaded.com.github.dockerjava.api.model;

import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.api.model.DockerObject;
import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.api.model.Repository;
import java.io.Serializable;
import java.util.Optional;

public class Identifier
extends DockerObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final Repository repository;
    public final Optional<String> tag;

    public Identifier(Repository repository, String tag) {
        this.repository = repository;
        this.tag = Optional.ofNullable(tag);
    }

    public static Identifier fromCompoundString(String identifier) {
        String[] parts = identifier.split("/");
        if (parts.length != 2) {
            String[] rhs = identifier.split(":");
            if (rhs.length != 2) {
                return new Identifier(new Repository(identifier), null);
            }
            return new Identifier(new Repository(rhs[0]), rhs[1]);
        }
        String[] rhs = parts[1].split(":");
        if (rhs.length != 2) {
            return new Identifier(new Repository(identifier), null);
        }
        return new Identifier(new Repository(parts[0] + "/" + rhs[0]), rhs[1]);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Identifier)) {
            return false;
        }
        Identifier other = (Identifier)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Repository this$repository = this.repository;
        Repository other$repository = other.repository;
        if (this$repository == null ? other$repository != null : !((Object)this$repository).equals(other$repository)) {
            return false;
        }
        Optional<String> this$tag = this.tag;
        Optional<String> other$tag = other.tag;
        return !(this$tag == null ? other$tag != null : !((Object)this$tag).equals(other$tag));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Identifier;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Repository $repository = this.repository;
        result = result * 59 + ($repository == null ? 43 : ((Object)$repository).hashCode());
        Optional<String> $tag = this.tag;
        result = result * 59 + ($tag == null ? 43 : ((Object)$tag).hashCode());
        return result;
    }

    public String toString() {
        return "Identifier(repository=" + this.repository + ", tag=" + this.tag + ")";
    }
}

